/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;

class ResizeComponentListener
extends ComponentAdapter {
    private static final String BOUNDS_PROPERTY_NAME = "frame.bounds";
    private final JFrame frame;

    static void attachToWindow(JFrame frame) {
        frame.addComponentListener(new ResizeComponentListener(frame));
    }

    static void setBoundsProperty(JFrame frame, Rectangle bounds) {
        frame.getRootPane().putClientProperty(BOUNDS_PROPERTY_NAME, bounds);
    }

    static Rectangle getBoundsProperty(JFrame frame) {
        return (Rectangle)frame.getRootPane().getClientProperty(BOUNDS_PROPERTY_NAME);
    }

    private ResizeComponentListener(JFrame frame) {
        this.frame = frame;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if ((this.frame.getExtendedState() & 6) == 0) {
            this.frame.getRootPane().putClientProperty(BOUNDS_PROPERTY_NAME, this.frame.getBounds());
        }
    }
}

