/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterManager;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSDictionaryMap;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.COSStreamArray;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;

public class PDStream
implements COSObjectable {
    private COSStream stream;

    protected PDStream() {
    }

    public PDStream(PDDocument document) {
        this.stream = new COSStream(document.getDocument().getScratchFile());
    }

    public PDStream(COSStream str) {
        this.stream = str;
    }

    public PDStream(PDDocument doc, InputStream str) throws IOException {
        this(doc, str, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDStream(PDDocument doc, InputStream str, boolean filtered) throws IOException {
        OutputStream output = null;
        try {
            this.stream = new COSStream(doc.getDocument().getScratchFile());
            output = filtered ? this.stream.createFilteredStream() : this.stream.createUnfilteredStream();
            byte[] buffer = new byte[1024];
            int amountRead = -1;
            while ((amountRead = str.read(buffer)) != -1) {
                output.write(buffer, 0, amountRead);
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (str != null) {
                str.close();
            }
        }
    }

    public void addCompression() {
        ArrayList<COSName> filters = this.getFilters();
        if (filters == null) {
            filters = new ArrayList<COSName>();
            filters.add(COSName.FLATE_DECODE);
            this.setFilters(filters);
        }
    }

    public static PDStream createFromCOS(COSBase base) throws IOException {
        PDStream retval = null;
        if (base instanceof COSStream) {
            retval = new PDStream((COSStream)base);
        } else if (base instanceof COSArray) {
            if (((COSArray)base).size() > 0) {
                retval = new PDStream(new COSStreamArray((COSArray)base));
            }
        } else if (base != null) {
            throw new IOException("Contents are unknown type:" + base.getClass().getName());
        }
        return retval;
    }

    public COSBase getCOSObject() {
        return this.stream;
    }

    public OutputStream createOutputStream() throws IOException {
        return this.stream.createUnfilteredStream();
    }

    public InputStream createInputStream() throws IOException {
        return this.stream.getUnfilteredStream();
    }

    public InputStream getPartiallyFilteredStream(List stopFilters) throws IOException {
        FilterManager manager = this.stream.getFilterManager();
        InputStream is = this.stream.getFilteredStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        List filters = this.getFilters();
        String nextFilter = null;
        boolean done = false;
        for (int i = 0; i < filters.size() && !done; ++i) {
            os.reset();
            nextFilter = (String)filters.get(i);
            if (stopFilters.contains(nextFilter)) {
                done = true;
                continue;
            }
            Filter filter = manager.getFilter(COSName.getPDFName(nextFilter));
            filter.decode(is, os, this.stream, i);
            is = new ByteArrayInputStream(os.toByteArray());
        }
        return is;
    }

    public COSStream getStream() {
        return this.stream;
    }

    public int getLength() {
        return this.stream.getInt("Length", 0);
    }

    public List getFilters() {
        List retval = null;
        COSBase filters = this.stream.getFilters();
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            retval = new COSArrayList((Object)name.getName(), (COSBase)name, (COSDictionary)this.stream, COSName.FILTER);
        } else if (filters instanceof COSArray) {
            retval = COSArrayList.convertCOSNameCOSArrayToList((COSArray)filters);
        }
        return retval;
    }

    public void setFilters(List filters) {
        COSArray obj = COSArrayList.convertStringListToCOSNameCOSArray(filters);
        this.stream.setItem(COSName.FILTER, (COSBase)obj);
    }

    public List getDecodeParms() throws IOException {
        COSArrayList retval = null;
        COSBase dp = this.stream.getDictionaryObject(COSName.DECODE_PARMS);
        if (dp == null) {
            dp = this.stream.getDictionaryObject(COSName.DP);
        }
        if (dp instanceof COSDictionary) {
            COSDictionaryMap map = COSDictionaryMap.convertBasicTypesToMap((COSDictionary)dp);
            retval = new COSArrayList((Object)map, dp, (COSDictionary)this.stream, COSName.DECODE_PARMS);
        } else if (dp instanceof COSArray) {
            COSArray array = (COSArray)dp;
            ArrayList<COSDictionaryMap> actuals = new ArrayList<COSDictionaryMap>();
            for (int i = 0; i < array.size(); ++i) {
                actuals.add(COSDictionaryMap.convertBasicTypesToMap((COSDictionary)array.getObject(i)));
            }
            retval = new COSArrayList(actuals, array);
        }
        return retval;
    }

    public void setDecodeParms(List decodeParams) {
        this.stream.setItem(COSName.DECODE_PARMS, (COSBase)COSArrayList.converterToCOSArray(decodeParams));
    }

    public PDFileSpecification getFile() throws IOException {
        COSBase f = this.stream.getDictionaryObject(COSName.F);
        PDFileSpecification retval = PDFileSpecification.createFS(f);
        return retval;
    }

    public void setFile(PDFileSpecification f) {
        this.stream.setItem(COSName.F, (COSObjectable)f);
    }

    public List getFileFilters() {
        List retval = null;
        COSBase filters = this.stream.getDictionaryObject(COSName.F_FILTER);
        if (filters instanceof COSName) {
            COSName name = (COSName)filters;
            retval = new COSArrayList((Object)name.getName(), (COSBase)name, (COSDictionary)this.stream, COSName.F_FILTER);
        } else if (filters instanceof COSArray) {
            retval = COSArrayList.convertCOSNameCOSArrayToList((COSArray)filters);
        }
        return retval;
    }

    public void setFileFilters(List filters) {
        COSArray obj = COSArrayList.convertStringListToCOSNameCOSArray(filters);
        this.stream.setItem(COSName.F_FILTER, (COSBase)obj);
    }

    public List getFileDecodeParams() throws IOException {
        COSArrayList retval = null;
        COSBase dp = this.stream.getDictionaryObject(COSName.F_DECODE_PARMS);
        if (dp instanceof COSDictionary) {
            COSDictionaryMap map = COSDictionaryMap.convertBasicTypesToMap((COSDictionary)dp);
            retval = new COSArrayList((Object)map, dp, (COSDictionary)this.stream, COSName.F_DECODE_PARMS);
        } else if (dp instanceof COSArray) {
            COSArray array = (COSArray)dp;
            ArrayList<COSDictionaryMap> actuals = new ArrayList<COSDictionaryMap>();
            for (int i = 0; i < array.size(); ++i) {
                actuals.add(COSDictionaryMap.convertBasicTypesToMap((COSDictionary)array.getObject(i)));
            }
            retval = new COSArrayList(actuals, array);
        }
        return retval;
    }

    public void setFileDecodeParams(List decodeParams) {
        this.stream.setItem("FDecodeParams", (COSBase)COSArrayList.converterToCOSArray(decodeParams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        InputStream is = null;
        try {
            is = this.createInputStream();
            int amountRead = -1;
            while ((amountRead = is.read(buf)) != -1) {
                output.write(buf, 0, amountRead);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return output.toByteArray();
    }

    public String getInputStreamAsString() throws IOException {
        byte[] bStream = this.getByteArray();
        return new String(bStream, "ISO-8859-1");
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSBase mdStream = this.stream.getDictionaryObject(COSName.METADATA);
        if (mdStream != null) {
            if (mdStream instanceof COSStream) {
                retval = new PDMetadata((COSStream)mdStream);
            } else if (!(mdStream instanceof COSNull)) {
                throw new IllegalStateException("Expected a COSStream but was a " + mdStream.getClass().getSimpleName());
            }
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.stream.setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public int getDecodedStreamLength() {
        return this.stream.getInt(COSName.DL);
    }

    public void setDecodedStreamLength(int decodedStreamLength) {
        this.stream.setInt(COSName.DL, decodedStreamLength);
    }
}

