/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.GUIGlobals;

public class DragDropPane
extends JTabbedPane {
    private boolean draggingState = false;
    private int indexDraggedTab = -1;
    MarkerPane markerPane = new MarkerPane();

    public DragDropPane() {
        this.markerPane.setVisible(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int indexActTab = DragDropPane.this.getUI().tabForCoordinate(DragDropPane.this, e.getX(), e.getY());
                if (!DragDropPane.this.draggingState) {
                    if (indexActTab >= 0) {
                        DragDropPane.this.draggingState = true;
                        DragDropPane.this.indexDraggedTab = indexActTab;
                        DragDropPane.this.repaint();
                    }
                } else if (DragDropPane.this.indexDraggedTab >= 0 && indexActTab >= 0) {
                    boolean toTheLeft = (double)e.getX() <= DragDropPane.this.getUI().getTabBounds(DragDropPane.this, indexActTab).getCenterX();
                    DragDropPane.this.getRootPane().setGlassPane(DragDropPane.this.markerPane);
                    Rectangle actTabRect = SwingUtilities.convertRectangle(DragDropPane.this, DragDropPane.this.getBoundsAt(indexActTab), DragDropPane.this.markerPane);
                    if (toTheLeft) {
                        DragDropPane.this.markerPane.setPicLocation(new Point(actTabRect.x, actTabRect.y + actTabRect.height));
                    } else {
                        DragDropPane.this.markerPane.setPicLocation(new Point(actTabRect.x + actTabRect.width, actTabRect.y + actTabRect.height));
                    }
                    DragDropPane.this.markerPane.setVisible(true);
                    DragDropPane.this.markerPane.repaint();
                    DragDropPane.this.repaint();
                } else {
                    DragDropPane.this.markerPane.setVisible(false);
                    DragDropPane.this.markerPane.repaint();
                }
                super.mouseDragged(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                DragDropPane.this.markerPane.setVisible(false);
                int indexActTab = DragDropPane.this.getUI().tabForCoordinate(DragDropPane.this, e.getX(), e.getY());
                if (DragDropPane.this.indexDraggedTab >= 0 && indexActTab >= 0 && DragDropPane.this.indexDraggedTab != indexActTab && DragDropPane.this.draggingState) {
                    boolean toTheLeft = (double)e.getX() <= DragDropPane.this.getUI().getTabBounds(DragDropPane.this, indexActTab).getCenterX();
                    DragDropPane.this.markerPane.setVisible(false);
                    Component actTab = DragDropPane.this.getComponentAt(DragDropPane.this.indexDraggedTab);
                    String actTabTitle = DragDropPane.this.getTitleAt(DragDropPane.this.indexDraggedTab);
                    DragDropPane.this.removeTabAt(DragDropPane.this.indexDraggedTab);
                    int newTabPos = indexActTab < DragDropPane.this.indexDraggedTab ? (toTheLeft && indexActTab < DragDropPane.this.getTabCount() ? indexActTab : indexActTab + 1) : (toTheLeft && indexActTab > 0 ? indexActTab - 1 : indexActTab);
                    DragDropPane.this.insertTab(actTabTitle, null, actTab, null, newTabPos);
                    DragDropPane.this.setSelectedIndex(newTabPos);
                }
                DragDropPane.this.draggingState = false;
            }
        });
    }

    class MarkerPane
    extends JPanel {
        private Point locationP;
        private Image markerImg;

        public MarkerPane() {
            this.setOpaque(false);
            this.markerImg = Toolkit.getDefaultToolkit().getImage(GUIGlobals.getIconUrl("dragNdropArrow"));
        }

        @Override
        public void paintComponent(Graphics g) {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.9f));
            g.drawImage(this.markerImg, this.locationP.x - this.markerImg.getWidth(null) / 2, this.locationP.y, null);
        }

        public void setPicLocation(Point pt) {
            this.locationP = pt;
        }
    }
}

