/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.rfc6455;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.SecKey;

public class RFC6455HandShake
extends HandShake {
    private SecKey secKey;
    private List<String> enabledExtensions = Collections.emptyList();
    private List<String> enabledProtocols = Collections.emptyList();

    public RFC6455HandShake(URI uri) {
        super(uri);
        this.secKey = new SecKey();
    }

    public RFC6455HandShake(HttpRequestPacket request) {
        super(request);
        MimeHeaders mimeHeaders = request.getHeaders();
        String header = mimeHeaders.getHeader("Sec-WebSocket-Extensions");
        if (header != null) {
            this.setExtensions(this.parseExtensionsHeader(header));
        }
        this.secKey = SecKey.generateServerKey(new SecKey(mimeHeaders.getHeader("Sec-WebSocket-Key")));
    }

    @Override
    protected int getVersion() {
        return 13;
    }

    @Override
    public void setHeaders(HttpResponsePacket response) {
        response.setReasonPhrase("Switching Protocols");
        response.setHeader("Sec-WebSocket-Accept", this.secKey.getSecKey());
        if (!this.getEnabledExtensions().isEmpty()) {
            response.setHeader("Sec-WebSocket-Extensions", this.join(this.getSubProtocol()));
        }
    }

    @Override
    public HttpContent composeHeaders() {
        HttpContent content = super.composeHeaders();
        HttpHeader header = content.getHttpHeader();
        header.addHeader("Sec-WebSocket-Key", this.secKey.toString());
        header.addHeader("Sec-WebSocket-Origin", this.getOrigin());
        header.addHeader("Sec-WebSocket-Version", this.getVersion() + "");
        if (!this.getExtensions().isEmpty()) {
            header.addHeader("Sec-WebSocket-Extensions", this.joinExtensions(this.getExtensions()));
        }
        String headerValue = header.getHeaders().getHeader("Sec-WebSocket-Origin");
        header.getHeaders().removeHeader("Sec-WebSocket-Origin");
        header.addHeader("Origin", headerValue);
        return content;
    }

    @Override
    public void validateServerResponse(HttpResponsePacket headers) throws HandshakeException {
        super.validateServerResponse(headers);
        this.secKey.validateServerKey(headers.getHeader("Sec-WebSocket-Accept"));
    }

    public List<String> getEnabledExtensions() {
        return this.enabledExtensions;
    }

    public List<String> getEnabledProtocols() {
        return this.enabledProtocols;
    }
}

