/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.misc;

import com.sun.security.sasl.preview.SaslClient;
import com.sun.security.sasl.preview.SaslException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CramMD5
implements SaslClient {
    private boolean completed = false;
    private byte[] pw;
    private String username;
    private static final int MD5_BLOCKSIZE = 64;

    public CramMD5(String string, byte[] byArray) throws SaslException {
        if (string == null || byArray == null) {
            throw new SaslException("CRAM-MD5: authentication ID and password must be specified");
        }
        this.username = string;
        this.pw = byArray;
    }

    /*
     * Unable to fully structure code
     */
    private static final String HMAC_MD5(byte[] var0, byte[] var1_1) throws NoSuchAlgorithmException {
        var2_2 = MessageDigest.getInstance("MD5");
        if (var0.length > 64) {
            var0 = var2_2.digest(var0);
        }
        var3_3 = new byte[64];
        var4_4 = new byte[64];
        var6_5 = 0;
        ** GOTO lbl16
        {
            var3_3[var6_5] = var0[var6_5];
            var4_4[var6_5] = var0[var6_5];
            ++var6_5;
            do {
                if (var6_5 < var0.length) continue block0;
                var3_3[var6_5] = 0;
                var4_4[var6_5] = 0;
                ++var6_5;
lbl16:
                // 2 sources

            } while (var6_5 < 64);
        }
        var6_5 = 0;
        while (var6_5 < 64) {
            v0 = var6_5;
            var3_3[v0] = (byte)(var3_3[v0] ^ 54);
            v1 = var6_5++;
            var4_4[v1] = (byte)(var4_4[v1] ^ 92);
        }
        var2_2.update(var3_3);
        var2_2.update(var1_1);
        var5_6 = var2_2.digest();
        var2_2.update(var4_4);
        var2_2.update(var5_6);
        var5_6 = var2_2.digest();
        var7_7 = new StringBuffer();
        var6_5 = 0;
        while (var6_5 < var5_6.length) {
            if ((var5_6[var6_5] & 255) < 16) {
                var7_7.append("0" + Integer.toHexString(var5_6[var6_5] & 255));
            } else {
                var7_7.append(Integer.toHexString(var5_6[var6_5] & 255));
            }
            ++var6_5;
        }
        return var7_7.toString();
    }

    private void clearPassword() {
        if (this.pw != null) {
            int n = 0;
            while (n < this.pw.length) {
                this.pw[n] = 0;
                ++n;
            }
            this.pw = null;
        }
    }

    public void dispose() throws SaslException {
    }

    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new SaslException("Already completed");
        }
        this.completed = true;
        try {
            String string = CramMD5.HMAC_MD5(this.pw, byArray);
            this.clearPassword();
            String string2 = String.valueOf(this.username) + " " + string;
            return string2.getBytes("UTF8");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SaslException("MD5 algorithm not available on platform", (Throwable)noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SaslException("UTF8 not available on platform", (Throwable)unsupportedEncodingException);
        }
    }

    protected void finalize() {
        this.clearPassword();
    }

    public String getMechanismName() {
        return "CRAM-MD5";
    }

    public String getNegotiatedProperty(String string) throws SaslException {
        if (this.completed) {
            if (string.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new SaslException("Not completed");
    }

    public boolean hasInitialResponse() {
        return false;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("CRAM-MD5 supports neither integrity nor privacy");
        }
        throw new SaslException("Not completed");
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (this.completed) {
            throw new SaslException("CRAM-MD5  supports neither integrity nor privacy");
        }
        throw new SaslException("Not completed");
    }
}

