/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jersey.repackaged.com.google.common.base.Function;
import org.glassfish.hk2.api.Factory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.Inflecting;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.routing.Router;

public final class Routers {
    private Routers() {
    }

    public static Router asTreeAcceptor(Inflector<RequestProcessingContext, ContainerResponse> inflector) {
        return new InflectingRouter(inflector);
    }

    public static Router.Builder acceptingTree(Function<RequestProcessingContext, RequestProcessingContext> transformation) {
        return new RouterBuilder(transformation);
    }

    private static class InflectingRouter
    implements Router,
    Inflecting<RequestProcessingContext, ContainerResponse> {
        private final Inflector<RequestProcessingContext, ContainerResponse> inflector;

        public InflectingRouter(Inflector<RequestProcessingContext, ContainerResponse> inflector) {
            this.inflector = inflector;
        }

        public Inflector<RequestProcessingContext, ContainerResponse> inflector() {
            return this.inflector;
        }

        @Override
        public Router.Continuation apply(RequestProcessingContext context) {
            return Router.Continuation.of(context);
        }
    }

    private static class LinkedRouter
    implements Router {
        private final Function<RequestProcessingContext, RequestProcessingContext> transformation;
        private final List<Router> children;

        public LinkedRouter(Function<RequestProcessingContext, RequestProcessingContext> transformation, List<Router> children) {
            this.transformation = transformation;
            this.children = children;
        }

        public LinkedRouter(Function<RequestProcessingContext, RequestProcessingContext> transformation) {
            this.transformation = transformation;
            this.children = Collections.emptyList();
        }

        @Override
        public Router.Continuation apply(RequestProcessingContext data) {
            return Router.Continuation.of((RequestProcessingContext)this.transformation.apply((Object)data), this.children);
        }
    }

    public static interface RootRouteBuilder<T>
    extends RouteBuilder<T> {
        public Router root(Router var1);
    }

    public static interface RouteBuilder<T> {
        public RouteToBuilder<T> route(String var1);

        public RouteToBuilder<T> route(T var1);
    }

    public static interface RouteToBuilder<T> {
        public RouteToPathBuilder<T> to(Router.Builder var1);

        public RouteToPathBuilder<T> to(Router var1);

        public RouteToPathBuilder<T> to(Class<? extends Router> var1);

        public RouteToPathBuilder<T> to(Factory<? extends Router> var1);
    }

    public static interface RouteToPathBuilder<T>
    extends RouteBuilder<T>,
    RouteToBuilder<T>,
    Router.Builder {
    }

    private static class RouterBuilder
    implements Router.Builder {
        private final Function<RequestProcessingContext, RequestProcessingContext> transformation;
        private List<Router> children;

        public RouterBuilder(Function<RequestProcessingContext, RequestProcessingContext> transformation) {
            this.transformation = transformation;
        }

        @Override
        public Router.Builder child(Router child) {
            if (this.children == null) {
                this.children = new LinkedList<Router>();
            }
            this.children.add(child);
            return this;
        }

        @Override
        public Router build() {
            return this.children == null ? new LinkedRouter(this.transformation) : new LinkedRouter(this.transformation, this.children);
        }
    }
}

