/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.Buffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import java.io.IOException;

public final class StatefulBuffer
extends Buffer {
    private int i_address;
    private int _addressOffset;
    private int i_cascadeDelete;
    private Tree i_embedded;
    private int i_id;
    private int i_instantionDepth;
    private int i_length;
    Transaction i_trans;
    private int i_updateDepth = 1;
    public int _payloadOffset;

    public StatefulBuffer(Transaction transaction, int n) {
        this.i_trans = transaction;
        this.i_length = n;
        this._buffer = new byte[this.i_length];
    }

    public StatefulBuffer(Transaction transaction, int n, int n2) {
        this(transaction, n2);
        this.i_address = n;
    }

    public StatefulBuffer(StatefulBuffer statefulBuffer, StatefulBuffer[] statefulBufferArray, int n) {
        statefulBufferArray[n++] = this;
        int n2 = statefulBuffer.readInt();
        this.i_length = statefulBuffer.readInt();
        this.i_id = statefulBuffer.readInt();
        statefulBufferArray[n2].addEmbedded(this);
        this.i_address = statefulBuffer.readInt();
        this.i_trans = statefulBuffer.getTransaction();
        this._buffer = new byte[this.i_length];
        System.arraycopy(statefulBuffer._buffer, statefulBuffer._offset, this._buffer, 0, this.i_length);
        statefulBuffer._offset += this.i_length;
        if (n < statefulBufferArray.length) {
            new StatefulBuffer(statefulBuffer, statefulBufferArray, n);
        }
    }

    public void addEmbedded(StatefulBuffer statefulBuffer) {
        this.i_embedded = Tree.add(this.i_embedded, new TreeIntObject(statefulBuffer.getID(), statefulBuffer));
    }

    public int appendTo(final Buffer buffer, int n) {
        buffer.writeInt(this.i_length);
        buffer.writeInt(this.i_id);
        buffer.writeInt(this.i_address);
        buffer.append(this._buffer);
        final int[] nArray = new int[]{++n};
        final int n2 = n;
        this.forEachEmbedded(new StatefulBufferVisitor(){

            public void visit(StatefulBuffer statefulBuffer) {
                buffer.writeInt(n2);
                nArray[0] = statefulBuffer.appendTo(buffer, nArray[0]);
            }
        });
        return nArray[0];
    }

    public int cascadeDeletes() {
        return this.i_cascadeDelete;
    }

    public void debugCheckBytes() {
    }

    public int embeddedCount() {
        final int[] nArray = new int[]{0};
        this.forEachEmbedded(new StatefulBufferVisitor(){

            public void visit(StatefulBuffer statefulBuffer) {
                nArray[0] = nArray[0] + (1 + statefulBuffer.embeddedCount());
            }
        });
        return nArray[0];
    }

    public int embeddedLength() {
        final int[] nArray = new int[]{0};
        this.forEachEmbedded(new StatefulBufferVisitor(){

            public void visit(StatefulBuffer statefulBuffer) {
                nArray[0] = nArray[0] + (statefulBuffer.getLength() + statefulBuffer.embeddedLength());
            }
        });
        return nArray[0];
    }

    private void forEachEmbedded(final StatefulBufferVisitor statefulBufferVisitor) {
        if (this.i_embedded != null) {
            this.i_embedded.traverse(new Visitor4(){

                public void visit(Object object) {
                    statefulBufferVisitor.visit((StatefulBuffer)((TreeIntObject)object)._object);
                }
            });
        }
    }

    public int getAddress() {
        return this.i_address;
    }

    public int addressOffset() {
        return this._addressOffset;
    }

    public int getID() {
        return this.i_id;
    }

    public int getInstantiationDepth() {
        return this.i_instantionDepth;
    }

    public int getLength() {
        return this.i_length;
    }

    public ObjectContainerBase getStream() {
        return this.i_trans.stream();
    }

    public ObjectContainerBase stream() {
        return this.i_trans.stream();
    }

    public LocalObjectContainer file() {
        return this.i_trans.i_file;
    }

    public Transaction getTransaction() {
        return this.i_trans;
    }

    public int getUpdateDepth() {
        return this.i_updateDepth;
    }

    public byte[] getWrittenBytes() {
        byte[] byArray = new byte[this._offset];
        System.arraycopy(this._buffer, 0, byArray, 0, this._offset);
        return byArray;
    }

    public int preparePayloadRead() {
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this._offset;
        this._offset = n;
        this._payloadOffset += n2;
        return n3;
    }

    public void read() {
        this.stream().readBytes(this._buffer, this.i_address, this._addressOffset, this.i_length);
    }

    public final boolean read(Socket4 socket4) throws IOException {
        int n;
        int n2 = 0;
        for (int i = this.i_length; i > 0; i -= n) {
            n = socket4.read(this._buffer, n2, i);
            if (n < 0) {
                return false;
            }
            n2 += n;
        }
        return true;
    }

    public final StatefulBuffer readEmbeddedObject() {
        int n = this.readInt();
        int n2 = this.readInt();
        StatefulBuffer statefulBuffer = null;
        TreeInt treeInt = TreeInt.find(this.i_embedded, n);
        if (treeInt != null) {
            statefulBuffer = (StatefulBuffer)((TreeIntObject)treeInt)._object;
        } else {
            statefulBuffer = this.stream().readWriterByAddress(this.i_trans, n, n2);
            if (statefulBuffer != null) {
                statefulBuffer.setID(n);
            }
        }
        if (statefulBuffer != null) {
            statefulBuffer.setUpdateDepth(this.getUpdateDepth());
            statefulBuffer.setInstantiationDepth(this.getInstantiationDepth());
        }
        return statefulBuffer;
    }

    public final StatefulBuffer readYapBytes() {
        int n = this.readInt();
        if (n == 0) {
            return null;
        }
        StatefulBuffer statefulBuffer = new StatefulBuffer(this.i_trans, n);
        System.arraycopy(this._buffer, this._offset, statefulBuffer._buffer, 0, n);
        this._offset += n;
        return statefulBuffer;
    }

    public void removeFirstBytes(int n) {
        this.i_length -= n;
        byte[] byArray = new byte[this.i_length];
        System.arraycopy(this._buffer, n, byArray, 0, this.i_length);
        this._buffer = byArray;
        this._offset -= n;
        if (this._offset < 0) {
            this._offset = 0;
        }
    }

    public void address(int n) {
        this.i_address = n;
    }

    public void setCascadeDeletes(int n) {
        this.i_cascadeDelete = n;
    }

    public void setID(int n) {
        this.i_id = n;
    }

    public void setInstantiationDepth(int n) {
        this.i_instantionDepth = n;
    }

    public void setTransaction(Transaction transaction) {
        this.i_trans = transaction;
    }

    public void setUpdateDepth(int n) {
        this.i_updateDepth = n;
    }

    public void slotDelete() {
        this.i_trans.slotDelete(this.i_id, this.i_address, this.i_length);
    }

    public void trim4(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this._buffer, n, byArray, 0, n2);
        this._buffer = byArray;
        this.i_length = n2;
    }

    public void useSlot(int n) {
        this.i_address = n;
        this._offset = 0;
    }

    public void useSlot(int n, int n2) {
        this.i_address = n;
        this._offset = 0;
        if (n2 > this._buffer.length) {
            this._buffer = new byte[n2];
        }
        this.i_length = n2;
    }

    public void useSlot(int n, int n2, int n3) {
        this.i_id = n;
        this.useSlot(n2, n3);
    }

    public void write() {
        this.file().writeBytes(this, this.i_address, this._addressOffset);
    }

    public void writeEmbedded() {
        final StatefulBuffer statefulBuffer = this;
        this.forEachEmbedded(new StatefulBufferVisitor(){

            public void visit(StatefulBuffer statefulBuffer2) {
                statefulBuffer2.writeEmbedded();
                StatefulBuffer.this.stream().writeEmbedded(statefulBuffer, statefulBuffer2);
            }
        });
        this.i_embedded = null;
    }

    public void writeEmbeddedNull() {
        this.writeInt(0);
        this.writeInt(0);
    }

    public void writeEncrypt() {
        this.writeEncrypt(this.file(), this.i_address, this._addressOffset);
    }

    public void writePayload(StatefulBuffer statefulBuffer, boolean bl) {
        this.checkMinimumPayLoadOffsetAndWritePointerAndLength(statefulBuffer.getLength(), bl);
        System.arraycopy(statefulBuffer._buffer, 0, this._buffer, this._payloadOffset, statefulBuffer._buffer.length);
        this.transferPayLoadAddress(statefulBuffer, this._payloadOffset);
        this._payloadOffset += statefulBuffer._buffer.length;
    }

    private void checkMinimumPayLoadOffsetAndWritePointerAndLength(int n, boolean bl) {
        if (this._payloadOffset <= this._offset + 8) {
            this._payloadOffset = this._offset + 8;
        }
        if (bl) {
            this._payloadOffset = this.stream().alignToBlockSize(this._payloadOffset);
        }
        this.writeInt(this._payloadOffset);
        this.writeInt(n);
    }

    public int reserveAndPointToPayLoadSlot(int n) {
        this.checkMinimumPayLoadOffsetAndWritePointerAndLength(n, false);
        int n2 = this._offset;
        this._offset = this._payloadOffset;
        this._payloadOffset += n;
        return n2;
    }

    public Buffer readPayloadWriter(int n, int n2) {
        StatefulBuffer statefulBuffer = new StatefulBuffer(this.i_trans, 0, n2);
        System.arraycopy(this._buffer, n, statefulBuffer._buffer, 0, n2);
        this.transferPayLoadAddress(statefulBuffer, n);
        return statefulBuffer;
    }

    private void transferPayLoadAddress(StatefulBuffer statefulBuffer, int n) {
        int n2 = n / this.stream().blockSize();
        statefulBuffer.i_id = statefulBuffer.i_address = this.i_address + n2;
        statefulBuffer._addressOffset = this._addressOffset;
    }

    void writeShortString(String string) {
        this.writeShortString(this.i_trans, string);
    }

    public void moveForward(int n) {
        this._addressOffset += n;
    }

    public void writeForward() {
        this.write();
        this._addressOffset += this.i_length;
        this._offset = 0;
    }

    public String toString() {
        return super.toString();
    }

    public void noXByteCheck() {
    }

    public void writeIDs(IntIterator4 intIterator4, int n) {
        int n2 = this._offset;
        this.writeInt(0);
        int n3 = 0;
        while (intIterator4.moveNext()) {
            this.writeInt(intIterator4.currentInt());
            if (++n3 < n) continue;
        }
        int n4 = this._offset;
        this._offset = n2;
        this.writeInt(n3);
        this._offset = n4;
    }

    private static interface StatefulBufferVisitor {
        public void visit(StatefulBuffer var1);
    }
}

