/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ReplicationImpl;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.BlobImpl;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.Const4;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.PrimitiveFieldHandler;
import com.db4o.internal.SharedIndexedFields;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.UntypedFieldHandler;
import com.db4o.internal.VirtualFieldMetadata;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.internal.handlers.ArrayHandler;
import com.db4o.internal.handlers.BooleanHandler;
import com.db4o.internal.handlers.ByteHandler;
import com.db4o.internal.handlers.CharHandler;
import com.db4o.internal.handlers.DateHandler;
import com.db4o.internal.handlers.DoubleHandler;
import com.db4o.internal.handlers.FloatHandler;
import com.db4o.internal.handlers.IntHandler;
import com.db4o.internal.handlers.LongHandler;
import com.db4o.internal.handlers.MultidimensionalArrayHandler;
import com.db4o.internal.handlers.NetTypeHandler;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.handlers.ShortHandler;
import com.db4o.internal.handlers.StringHandler;
import com.db4o.internal.replication.Db4oReplicationReferenceProvider;
import com.db4o.internal.replication.MigrationConnection;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectConstructor;
import com.db4o.reflect.generic.GenericConverter;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.types.Db4oCollections;

public final class HandlerRegistry {
    private final ObjectContainerBase _masterStream;
    private static final Db4oTypeImpl[] i_db4oTypes = new Db4oTypeImpl[]{new BlobImpl()};
    public static final int ANY_ARRAY_ID = 12;
    public static final int ANY_ARRAY_N_ID = 13;
    private static final int CLASSCOUNT = 11;
    private ClassMetadata i_anyArray;
    private ClassMetadata i_anyArrayN;
    public final StringHandler i_stringHandler;
    private TypeHandler4[] i_handlers;
    private int i_maxTypeID = 14;
    private NetTypeHandler[] i_platformTypes;
    private static final int PRIMITIVECOUNT = 8;
    ClassMetadata[] i_yapClasses;
    private static final int ANY_INDEX = 10;
    public static final int ANY_ID = 11;
    private final VirtualFieldMetadata[] _virtualFields = new VirtualFieldMetadata[2];
    private final Hashtable4 i_classByClass = new Hashtable4(32);
    Db4oCollections i_collections;
    SharedIndexedFields i_indexes;
    ReplicationImpl i_replication;
    MigrationConnection i_migration;
    Db4oReplicationReferenceProvider _replicationReferenceProvider;
    public final DiagnosticProcessor _diagnosticProcessor;
    public boolean i_encrypt;
    byte[] i_encryptor;
    int i_lastEncryptorByte;
    final GenericReflector _reflector;
    public ReflectClass ICLASS_COMPARE;
    ReflectClass ICLASS_DB4OTYPE;
    ReflectClass ICLASS_DB4OTYPEIMPL;
    public ReflectClass ICLASS_INTERNAL;
    ReflectClass ICLASS_UNVERSIONED;
    public ReflectClass ICLASS_OBJECT;
    ReflectClass ICLASS_OBJECTCONTAINER;
    public ReflectClass ICLASS_STATICCLASS;
    public ReflectClass ICLASS_STRING;
    ReflectClass ICLASS_TRANSIENTCLASS;

    HandlerRegistry(ObjectContainerBase objectContainerBase, byte by, GenericReflector genericReflector) {
        int n;
        int n2;
        int n3;
        this._masterStream = objectContainerBase;
        objectContainerBase.i_handlers = this;
        this._reflector = genericReflector;
        this._diagnosticProcessor = objectContainerBase.configImpl().diagnosticProcessor();
        this.initClassReflectors(genericReflector);
        this.i_indexes = new SharedIndexedFields(objectContainerBase);
        this._virtualFields[0] = this.i_indexes.i_fieldVersion;
        this._virtualFields[1] = this.i_indexes.i_fieldUUID;
        this.i_stringHandler = new StringHandler(objectContainerBase, LatinStringIO.forEncoding(by));
        this.i_handlers = new TypeHandler4[]{new IntHandler(objectContainerBase), new LongHandler(objectContainerBase), new FloatHandler(objectContainerBase), new BooleanHandler(objectContainerBase), new DoubleHandler(objectContainerBase), new ByteHandler(objectContainerBase), new CharHandler(objectContainerBase), new ShortHandler(objectContainerBase), this.i_stringHandler, new DateHandler(objectContainerBase), new UntypedFieldHandler(objectContainerBase)};
        this.i_platformTypes = Platform4.types(objectContainerBase);
        if (this.i_platformTypes.length > 0) {
            for (int i = 0; i < this.i_platformTypes.length; ++i) {
                this.i_platformTypes[i].initialize();
                if (this.i_platformTypes[i].getID() <= this.i_maxTypeID) continue;
                this.i_maxTypeID = this.i_platformTypes[i].getID();
            }
            TypeHandler4[] typeHandler4Array = this.i_handlers;
            this.i_handlers = new TypeHandler4[this.i_maxTypeID];
            System.arraycopy(typeHandler4Array, 0, this.i_handlers, 0, typeHandler4Array.length);
            for (n3 = 0; n3 < this.i_platformTypes.length; ++n3) {
                n2 = this.i_platformTypes[n3].getID() - 1;
                this.i_handlers[n2] = this.i_platformTypes[n3];
            }
        }
        this.i_yapClasses = new ClassMetadata[this.i_maxTypeID + 1];
        for (n = 0; n < 11; ++n) {
            n3 = n + 1;
            this.i_yapClasses[n] = new PrimitiveFieldHandler(objectContainerBase, this.i_handlers[n]);
            this.i_yapClasses[n].setID(n3);
            this.i_classByClass.put(this.i_handlers[n].classReflector(), (Object)this.i_yapClasses[n]);
            if (n < 10) {
                genericReflector.registerPrimitiveClass(n3, this.i_handlers[n].classReflector().getName(), null);
            }
            if (this.i_handlers[n].primitiveClassReflector() == null) continue;
            this.i_classByClass.put(this.i_handlers[n].primitiveClassReflector(), (Object)this.i_yapClasses[n]);
        }
        for (n = 0; n < this.i_platformTypes.length; ++n) {
            n3 = this.i_platformTypes[n].getID();
            n2 = n3 - 1;
            GenericConverter genericConverter = this.i_platformTypes[n] instanceof GenericConverter ? (GenericConverter)((Object)this.i_platformTypes[n]) : null;
            genericReflector.registerPrimitiveClass(n3, this.i_platformTypes[n].getName(), genericConverter);
            this.i_handlers[n2] = this.i_platformTypes[n];
            this.i_yapClasses[n2] = new PrimitiveFieldHandler(objectContainerBase, this.i_platformTypes[n]);
            this.i_yapClasses[n2].setID(n3);
            if (n3 > this.i_maxTypeID) {
                this.i_maxTypeID = n2;
            }
            this.i_classByClass.put(this.i_platformTypes[n].classReflector(), (Object)this.i_yapClasses[n2]);
            if (this.i_platformTypes[n].primitiveClassReflector() == null) continue;
            this.i_classByClass.put(this.i_platformTypes[n].primitiveClassReflector(), (Object)this.i_yapClasses[n2]);
        }
        this.i_anyArray = new PrimitiveFieldHandler(objectContainerBase, new ArrayHandler(this._masterStream, this.untypedHandler(), false));
        this.i_anyArray.setID(12);
        this.i_yapClasses[11] = this.i_anyArray;
        this.i_anyArrayN = new PrimitiveFieldHandler(objectContainerBase, new MultidimensionalArrayHandler(this._masterStream, this.untypedHandler(), false));
        this.i_anyArrayN.setID(13);
        this.i_yapClasses[12] = this.i_anyArrayN;
    }

    int arrayType(Object object) {
        ReflectClass reflectClass = this._masterStream.reflector().forObject(object);
        if (!reflectClass.isArray()) {
            return 0;
        }
        if (this._masterStream.reflector().array().isNDimensional(reflectClass)) {
            return 4;
        }
        return 3;
    }

    boolean createConstructor(final ReflectClass reflectClass, boolean bl) {
        if (reflectClass == null) {
            return false;
        }
        if (reflectClass.isAbstract() || reflectClass.isInterface()) {
            return true;
        }
        if (!Platform4.callConstructor() && reflectClass.skipConstructor(bl)) {
            return true;
        }
        if (!this._masterStream.configImpl().testConstructors()) {
            return true;
        }
        if (reflectClass.newInstance() != null) {
            return true;
        }
        if (this._masterStream.reflector().constructorCallsSupported()) {
            try {
                ReflectConstructor[] reflectConstructorArray = reflectClass.getDeclaredConstructors();
                Tree tree = null;
                for (int i = 0; i < reflectConstructorArray.length; ++i) {
                    try {
                        reflectConstructorArray[i].setAccessible();
                        int n = reflectConstructorArray[i].getParameterTypes().length;
                        tree = Tree.add(tree, new TreeIntObject(i + reflectConstructorArray.length * n, reflectConstructorArray[i]));
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                final boolean[] blArray = new boolean[]{false};
                if (tree != null) {
                    final TypeHandler4[] typeHandler4Array = this.i_handlers;
                    tree.traverse(new Visitor4(){

                        public void visit(Object object) {
                            if (!blArray[0]) {
                                ReflectConstructor reflectConstructor = (ReflectConstructor)((TreeIntObject)object)._object;
                                try {
                                    ReflectClass[] reflectClassArray = reflectConstructor.getParameterTypes();
                                    Object[] objectArray = new Object[reflectClassArray.length];
                                    block2: for (int i = 0; i < objectArray.length; ++i) {
                                        for (int j = 0; j < 8; ++j) {
                                            if (!reflectClassArray[i].equals(typeHandler4Array[j].primitiveClassReflector())) continue;
                                            objectArray[i] = ((PrimitiveHandler)typeHandler4Array[j]).primitiveNull();
                                            continue block2;
                                        }
                                    }
                                    Object object2 = reflectConstructor.newInstance(objectArray);
                                    if (object2 != null) {
                                        blArray[0] = true;
                                        reflectClass.useConstructor(reflectConstructor, objectArray);
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
                if (blArray[0]) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public final void decrypt(Buffer buffer) {
        if (this.i_encrypt) {
            int n = this.i_lastEncryptorByte;
            byte[] byArray = buffer._buffer;
            for (int i = buffer.getLength() - 1; i >= 0; --i) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] + this.i_encryptor[n]);
                if (n == 0) {
                    n = this.i_lastEncryptorByte;
                    continue;
                }
                --n;
            }
        }
    }

    public final void encrypt(Buffer buffer) {
        if (this.i_encrypt) {
            byte[] byArray = buffer._buffer;
            int n = this.i_lastEncryptorByte;
            for (int i = buffer.getLength() - 1; i >= 0; --i) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] - this.i_encryptor[n]);
                if (n == 0) {
                    n = this.i_lastEncryptorByte;
                    continue;
                }
                --n;
            }
        }
    }

    public void oldEncryptionOff() {
        this.i_encrypt = false;
        this.i_encryptor = null;
        this.i_lastEncryptorByte = 0;
        this._masterStream.configImpl().oldEncryptionOff();
    }

    final TypeHandler4 getHandler(int n) {
        return this.i_handlers[n - 1];
    }

    final TypeHandler4 handlerForClass(ReflectClass reflectClass, ReflectClass[] reflectClassArray) {
        for (int i = 0; i < reflectClassArray.length; ++i) {
            if (!reflectClassArray[i].equals(reflectClass)) continue;
            return this.i_handlers[i];
        }
        return null;
    }

    public final TypeHandler4 handlerForClass(ObjectContainerBase objectContainerBase, ReflectClass reflectClass) {
        if (reflectClass == null) {
            return null;
        }
        if (reflectClass.isArray()) {
            return this.handlerForClass(objectContainerBase, reflectClass.getComponentType());
        }
        ClassMetadata classMetadata = this.getYapClassStatic(reflectClass);
        if (classMetadata != null) {
            return ((PrimitiveFieldHandler)classMetadata).i_handler;
        }
        return objectContainerBase.produceYapClass(reflectClass);
    }

    public TypeHandler4 untypedHandler() {
        return this.i_handlers[10];
    }

    private void initClassReflectors(GenericReflector genericReflector) {
        this.ICLASS_COMPARE = genericReflector.forClass(Const4.CLASS_COMPARE);
        this.ICLASS_DB4OTYPE = genericReflector.forClass(Const4.CLASS_DB4OTYPE);
        this.ICLASS_DB4OTYPEIMPL = genericReflector.forClass(Const4.CLASS_DB4OTYPEIMPL);
        this.ICLASS_INTERNAL = genericReflector.forClass(Const4.CLASS_INTERNAL);
        this.ICLASS_UNVERSIONED = genericReflector.forClass(Const4.CLASS_UNVERSIONED);
        this.ICLASS_OBJECT = genericReflector.forClass(Const4.CLASS_OBJECT);
        this.ICLASS_OBJECTCONTAINER = genericReflector.forClass(Const4.CLASS_OBJECTCONTAINER);
        this.ICLASS_STATICCLASS = genericReflector.forClass(Const4.CLASS_STATICCLASS);
        this.ICLASS_STRING = genericReflector.forClass(String.class);
        this.ICLASS_TRANSIENTCLASS = genericReflector.forClass(Const4.CLASS_TRANSIENTCLASS);
        Platform4.registerCollections(genericReflector);
    }

    void initEncryption(Config4Impl config4Impl) {
        if (config4Impl.encrypt() && config4Impl.password() != null && config4Impl.password().length() > 0) {
            this.i_encrypt = true;
            this.i_encryptor = new byte[config4Impl.password().length()];
            for (int i = 0; i < this.i_encryptor.length; ++i) {
                this.i_encryptor[i] = (byte)(config4Impl.password().charAt(i) & 0xFF);
            }
            this.i_lastEncryptorByte = config4Impl.password().length() - 1;
            return;
        }
        this.oldEncryptionOff();
    }

    static Db4oTypeImpl getDb4oType(ReflectClass reflectClass) {
        for (int i = 0; i < i_db4oTypes.length; ++i) {
            if (!reflectClass.isInstance(i_db4oTypes[i])) continue;
            return i_db4oTypes[i];
        }
        return null;
    }

    public ClassMetadata getYapClassStatic(int n) {
        if (n > 0 && n <= this.i_maxTypeID) {
            return this.i_yapClasses[n - 1];
        }
        return null;
    }

    ClassMetadata getYapClassStatic(ReflectClass reflectClass) {
        if (reflectClass == null) {
            return null;
        }
        if (reflectClass.isArray()) {
            if (this._masterStream.reflector().array().isNDimensional(reflectClass)) {
                return this.i_anyArrayN;
            }
            return this.i_anyArray;
        }
        return (ClassMetadata)this.i_classByClass.get(reflectClass);
    }

    public boolean isSecondClass(Object object) {
        ReflectClass reflectClass;
        return object != null && this.i_classByClass.get(reflectClass = this._masterStream.reflector().forObject(object)) != null;
    }

    public boolean isSystemHandler(int n) {
        return n <= this.i_maxTypeID;
    }

    public void migrationConnection(MigrationConnection migrationConnection) {
        this.i_migration = migrationConnection;
    }

    public MigrationConnection migrationConnection() {
        return this.i_migration;
    }

    public void replication(ReplicationImpl replicationImpl) {
        this.i_replication = replicationImpl;
    }

    public ReplicationImpl replication() {
        return this.i_replication;
    }

    public ClassMetadata primitiveClassById(int n) {
        return this.i_yapClasses[n - 1];
    }

    public VirtualFieldMetadata virtualFieldByName(String string) {
        for (int i = 0; i < this._virtualFields.length; ++i) {
            if (!string.equals(this._virtualFields[i].getName())) continue;
            return this._virtualFields[i];
        }
        return null;
    }
}

