/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.views.explorer.BookMarkLabelProvider;
import org.rssowl.ui.internal.views.explorer.BookMarkSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderChildCheckboxTree {
    private Composite fParent;
    private CheckboxTreeViewer fViewer;
    private boolean fFlat;
    private final boolean fFullLabels;

    public FolderChildCheckboxTree(Composite parent) {
        this(parent, false);
    }

    public FolderChildCheckboxTree(Composite parent, boolean fullLabels) {
        this.fParent = parent;
        this.fFullLabels = fullLabels;
        this.initComponents();
    }

    public void setAllChecked(boolean checked) {
        OwlUI.setAllChecked(this.fViewer.getTree(), checked);
    }

    public void setFlat(boolean flat) {
        this.fFlat = flat;
        this.fViewer.refresh();
    }

    public CheckboxTreeViewer getViewer() {
        return this.fViewer;
    }

    public List<IFolderChild> getCheckedElements() {
        Object[] checkedElements;
        ArrayList<IFolderChild> folderChilds = new ArrayList<IFolderChild>();
        Object[] objectArray = checkedElements = this.fViewer.getCheckedElements();
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            if (checkedElement instanceof IFolderChild) {
                folderChilds.add((IFolderChild)checkedElement);
            }
            ++n2;
        }
        return folderChilds;
    }

    private void initComponents() {
        this.fViewer = new CheckboxTreeViewer(this.fParent, 2050);
        this.fViewer.setAutoExpandLevel(2);
        this.fViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.fViewer.getTree().getLayoutData()).heightHint = 80;
        this.fViewer.getTree().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        if (Owl.getPreferenceService().getGlobalScope().getBoolean(DefaultPreferences.BE_SORT_BY_NAME)) {
            BookMarkSorter sorter = new BookMarkSorter();
            sorter.setType(BookMarkSorter.Type.SORT_BY_NAME);
            this.fViewer.setComparator((ViewerComparator)sorter);
        }
        this.fViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (FolderChildCheckboxTree.this.fFlat) {
                    return FolderChildCheckboxTree.this.getNewsMarks((Collection)inputElement).toArray();
                }
                return ((Collection)inputElement).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof IFolder) {
                    IFolder folder = (IFolder)parentElement;
                    return folder.getChildren().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    return folder.getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    return !folder.isEmpty();
                }
                return false;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        boolean usedInDialog = this.fParent.getShell().getParent() != null;
        this.fViewer.setLabelProvider((IBaseLabelProvider)new BookMarkLabelProvider(this.fFullLabels, usedInDialog));
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FolderChildCheckboxTree.this.onDoubleClick(event);
            }
        });
        this.fViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FolderChildCheckboxTree.this.onSelect(e);
            }
        });
        this.fViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                FolderChildCheckboxTree.this.onExpand(event);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
    }

    private List<INewsMark> getNewsMarks(Collection<?> input) {
        ArrayList<INewsMark> childs = new ArrayList<INewsMark>();
        for (Object element : input) {
            if (element instanceof IFolder) {
                this.getNewsMarks(childs, (IFolder)element);
                continue;
            }
            if (!(element instanceof INewsMark)) continue;
            childs.add((INewsMark)element);
        }
        return childs;
    }

    private void getNewsMarks(List<INewsMark> childs, IFolder folder) {
        List children = folder.getChildren();
        for (IFolderChild child : children) {
            if (child instanceof IFolder) {
                this.getNewsMarks(childs, (IFolder)child);
                continue;
            }
            if (!(child instanceof INewsMark)) continue;
            childs.add((INewsMark)child);
        }
    }

    private void onSelect(SelectionEvent e) {
        if (e.detail == 32) {
            TreeItem item = (TreeItem)e.item;
            IFolderChild child = (IFolderChild)item.getData();
            this.setChildsChecked(child, item.getChecked());
            if (!item.getChecked()) {
                this.setParentsChecked(child, false);
            } else {
                this.updateParentsChecked(child);
            }
        }
    }

    private void onExpand(TreeExpansionEvent event) {
        boolean isChecked = this.fViewer.getChecked(event.getElement());
        if (isChecked) {
            this.setChildsChecked((IFolderChild)event.getElement(), true);
        }
    }

    private void onDoubleClick(DoubleClickEvent event) {
        IFolder folder;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        IFolder iFolder = folder = selection.getFirstElement() instanceof IFolder ? (IFolder)selection.getFirstElement() : null;
        if (folder != null && !folder.isEmpty()) {
            boolean expandedState = !this.fViewer.getExpandedState((Object)folder);
            this.fViewer.setExpandedState((Object)folder, expandedState);
            if (expandedState && this.fViewer.getChecked((Object)folder)) {
                this.setChildsChecked((IFolderChild)folder, true);
            }
        }
    }

    private void setChildsChecked(IFolderChild folderChild, boolean checked) {
        if (folderChild instanceof IFolder) {
            List children = ((IFolder)folderChild).getChildren();
            for (IFolderChild child : children) {
                this.fViewer.setChecked((Object)child, checked);
                this.setChildsChecked(child, checked);
            }
        }
    }

    private void setParentsChecked(IFolderChild folderChild, boolean checked) {
        IFolder parent = folderChild.getParent();
        if (parent != null) {
            this.fViewer.setChecked((Object)parent, checked);
            this.setParentsChecked((IFolderChild)parent, checked);
        }
    }

    private void updateParentsChecked(IFolderChild folderChild) {
        IFolder parent = folderChild.getParent();
        if (parent != null) {
            List children = parent.getChildren();
            for (IFolderChild child : children) {
                if (this.fViewer.getChecked((Object)child) || this.isFiltered(child)) continue;
                return;
            }
            this.fViewer.setChecked((Object)parent, true);
            this.updateParentsChecked((IFolderChild)parent);
        }
    }

    private boolean isFiltered(IFolderChild child) {
        ViewerFilter[] filters;
        ViewerFilter[] viewerFilterArray = filters = this.fViewer.getFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (!filter.select((Viewer)this.fViewer, (Object)child.getParent(), (Object)child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

