/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.ISearchMarkDAO;
import org.rssowl.core.persist.event.BookMarkAdapter;
import org.rssowl.core.persist.event.BookMarkEvent;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.FolderAdapter;
import org.rssowl.core.persist.event.FolderEvent;
import org.rssowl.core.persist.event.NewsBinAdapter;
import org.rssowl.core.persist.event.NewsBinEvent;
import org.rssowl.core.persist.event.SearchMarkEvent;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.service.IModelSearch;
import org.rssowl.core.persist.service.IndexListener;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.SearchHit;
import org.rssowl.ui.internal.Controller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavedSearchService {
    private static final int BATCH_INTERVAL_LONG = 1000;
    private static final int BATCH_INTERVAL_SHORT = 100;
    private static final int SHORT_THRESHOLD = 1;
    private final Job fBatchJob;
    private final AtomicBoolean fBatchInProcess = new AtomicBoolean(false);
    private final AtomicBoolean fUpdatedOnce = new AtomicBoolean(false);
    private final AtomicBoolean fForceQuickUpdate = new AtomicBoolean(false);
    private IndexListener fIndexListener;
    private BookMarkAdapter fBookmarkListener;
    private NewsBinAdapter fNewsBinListener;
    private FolderAdapter fFolderListener;

    public SavedSearchService() {
        this.fBatchJob = this.createBatchJob();
        this.registerListeners();
    }

    private Job createBatchJob() {
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                SavedSearchService.this.fBatchInProcess.set(false);
                SavedSearchService.this.fForceQuickUpdate.set(false);
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        if (!Controller.getDefault().isShuttingDown()) {
                            SavedSearchService.this.updateSavedSearches(true);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        return job;
    }

    private void registerListeners() {
        this.fIndexListener = new IndexListener(){

            public void indexUpdated(int entitiesCount) {
                SavedSearchService.this.updateSavedSearchesFromEvent(entitiesCount);
            }
        };
        Owl.getPersistenceService().getModelSearch().addIndexListener(this.fIndexListener);
        this.fBookmarkListener = new BookMarkAdapter(){

            public void entitiesUpdated(Set<BookMarkEvent> events) {
                for (BookMarkEvent event : events) {
                    if (!event.isRoot()) continue;
                    IFolder oldParent = event.getOldParent();
                    IFolder parent = event.getEntity().getParent();
                    if (oldParent == null || oldParent.equals(parent)) continue;
                    SavedSearchService.this.updateSavedSearchesFromEvent(1);
                    break;
                }
            }
        };
        DynamicDAO.addEntityListener(IBookMark.class, (EntityListener)this.fBookmarkListener);
        this.fNewsBinListener = new NewsBinAdapter(){

            public void entitiesUpdated(Set<NewsBinEvent> events) {
                for (NewsBinEvent event : events) {
                    if (!event.isRoot()) continue;
                    IFolder oldParent = event.getOldParent();
                    IFolder parent = event.getEntity().getParent();
                    if (oldParent == null || oldParent.equals(parent)) continue;
                    SavedSearchService.this.updateSavedSearchesFromEvent(1);
                    break;
                }
            }
        };
        DynamicDAO.addEntityListener(INewsBin.class, (EntityListener)this.fNewsBinListener);
        this.fFolderListener = new FolderAdapter(){

            public void entitiesUpdated(Set<FolderEvent> events) {
                for (FolderEvent event : events) {
                    if (!event.isRoot()) continue;
                    IFolder oldParent = event.getOldParent();
                    IFolder parent = event.getEntity().getParent();
                    if (oldParent == null || oldParent.equals(parent)) continue;
                    SavedSearchService.this.updateSavedSearchesFromEvent(1);
                    break;
                }
            }
        };
        DynamicDAO.addEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
    }

    private void updateSavedSearchesFromEvent(int entitiesCount) {
        if (!Controller.getDefault().isShuttingDown()) {
            if (!InternalOwl.TESTING) {
                this.onIndexUpdated(entitiesCount);
            } else {
                this.updateSavedSearches(true);
            }
        }
    }

    private void unregisterListeners() {
        Owl.getPersistenceService().getModelSearch().removeIndexListener(this.fIndexListener);
        DynamicDAO.removeEntityListener(IBookMark.class, (EntityListener)this.fBookmarkListener);
        DynamicDAO.removeEntityListener(INewsBin.class, (EntityListener)this.fNewsBinListener);
        DynamicDAO.removeEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
    }

    private void onIndexUpdated(int entitiesCount) {
        if (!this.fBatchInProcess.getAndSet(true)) {
            this.fBatchJob.schedule((long)(entitiesCount <= 1 || this.fForceQuickUpdate.get() ? 100 : 1000));
            return;
        }
    }

    public void forceQuickUpdate() {
        this.fForceQuickUpdate.set(true);
    }

    public void updateSavedSearches(boolean force) {
        if (!force && this.fUpdatedOnce.get()) {
            return;
        }
        Collection searchMarks = DynamicDAO.loadAll(ISearchMark.class);
        this.updateSavedSearches(searchMarks);
    }

    public void updateSavedSearches(Collection<ISearchMark> searchMarks) {
        this.updateSavedSearches(searchMarks, false);
    }

    public void updateSavedSearches(Collection<ISearchMark> searchMarks, boolean fromUserEvent) {
        boolean firstUpdate = !this.fUpdatedOnce.get();
        this.fUpdatedOnce.set(true);
        IModelSearch modelSearch = Owl.getPersistenceService().getModelSearch();
        HashSet<SearchMarkEvent> events = new HashSet<SearchMarkEvent>(searchMarks.size());
        for (ISearchMark searchMark : searchMarks) {
            if (Controller.getDefault().isShuttingDown()) {
                return;
            }
            List results = modelSearch.searchNews((Collection)searchMark.getSearchConditions(), searchMark.matchAllConditions());
            EnumMap<INews.State, ArrayList<NewsReference>> resultsMap = new EnumMap<INews.State, ArrayList<NewsReference>>(INews.State.class);
            Set visibleStates = INews.State.getVisible();
            for (SearchHit searchHit : results) {
                if (Controller.getDefault().isShuttingDown()) {
                    return;
                }
                INews.State state = (INews.State)searchHit.getData((Object)14);
                if (!visibleStates.contains(state)) continue;
                ArrayList<NewsReference> newsRefs = (ArrayList<NewsReference>)resultsMap.get(state);
                if (newsRefs == null) {
                    newsRefs = new ArrayList<NewsReference>(results.size() / 3);
                    resultsMap.put(state, newsRefs);
                }
                newsRefs.add((NewsReference)searchHit.getResult());
            }
            Pair result = searchMark.setNewsRefs(resultsMap);
            boolean changed = (Boolean)result.getFirst();
            boolean newNewsAdded = (Boolean)result.getSecond();
            if (!changed) continue;
            events.add(new SearchMarkEvent(searchMark, null, true, !firstUpdate && !fromUserEvent && newNewsAdded));
        }
        if (!events.isEmpty() && !Controller.getDefault().isShuttingDown()) {
            ((ISearchMarkDAO)DynamicDAO.getDAO(ISearchMarkDAO.class)).fireNewsChanged(events);
        }
    }

    public void stopService() {
        this.unregisterListeners();
    }
}

