/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.cleanup;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.ConfirmDialog;
import org.rssowl.ui.internal.dialogs.cleanup.BookMarkTask;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpIndexTask;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpOperations;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpOptionsPage;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpSummaryPage;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpTask;
import org.rssowl.ui.internal.dialogs.cleanup.DefragDatabaseTask;
import org.rssowl.ui.internal.dialogs.cleanup.DeleteOrphanedSearchMarkTask;
import org.rssowl.ui.internal.dialogs.cleanup.DisableOrphanedNewsFiltersTask;
import org.rssowl.ui.internal.dialogs.cleanup.FeedSelectionPage;
import org.rssowl.ui.internal.dialogs.cleanup.Messages;
import org.rssowl.ui.internal.dialogs.cleanup.NewsTask;
import org.rssowl.ui.internal.dialogs.cleanup.OptimizeSearchTask;

public class CleanUpWizard
extends Wizard {
    private CleanUpOptionsPage fCleanUpOptionsPage;
    private FeedSelectionPage fFeedSelectionPage;
    private CleanUpSummaryPage fCleanUpSummaryPage;

    public void addPages() {
        this.setWindowTitle(Messages.CleanUpWizard_CLEAN_UP);
        this.setHelpAvailable(false);
        this.fFeedSelectionPage = new FeedSelectionPage(Messages.CleanUpWizard_CHOOSE_BOOKMARKS);
        this.addPage((IWizardPage)this.fFeedSelectionPage);
        this.fCleanUpOptionsPage = new CleanUpOptionsPage(Messages.CleanUpWizard_CLEANUP_OPS);
        this.addPage((IWizardPage)this.fCleanUpOptionsPage);
        this.fCleanUpSummaryPage = new CleanUpSummaryPage(Messages.CleanUpWizard_SUMMARY);
        this.addPage((IWizardPage)this.fCleanUpSummaryPage);
    }

    public boolean performFinish() {
        boolean restart;
        final INewsDAO newsDao = (INewsDAO)DynamicDAO.getDAO(INewsDAO.class);
        final CleanUpOperations operations = this.fCleanUpOptionsPage.getOperations();
        final AtomicBoolean askForRestart = new AtomicBoolean(false);
        final List<CleanUpTask> tasks = this.fCleanUpSummaryPage.getTasks();
        StringBuilder smNames = new StringBuilder();
        int bmCounter = 0;
        int smCounter = 0;
        int newsCounter = 0;
        for (CleanUpTask task : tasks) {
            if (task instanceof BookMarkTask) {
                ++bmCounter;
                continue;
            }
            if (task instanceof NewsTask) {
                newsCounter += ((NewsTask)task).getNews().size();
                continue;
            }
            if (!(task instanceof DeleteOrphanedSearchMarkTask)) continue;
            List<ISearchMark> searches = ((DeleteOrphanedSearchMarkTask)task).getSearchMarks();
            smCounter += searches.size();
            for (ISearchMark search : searches) {
                smNames.append(search.getName()).append(", ");
            }
            if (smNames.length() == 0) continue;
            smNames.delete(smNames.length() - 2, smNames.length());
        }
        if (bmCounter != 0 || newsCounter != 0 || smCounter != 0) {
            StringBuilder msg = new StringBuilder(Messages.CleanUpWizard_PLEASE_CONFIRM_DELETE).append("\n\n");
            if (bmCounter == 1) {
                msg.append(Messages.CleanUpWizard_ONE_FEED).append("\n");
            } else if (bmCounter > 1) {
                msg.append(NLS.bind((String)Messages.CleanUpWizard_N_FEEDS, (Object)bmCounter)).append("\n");
            }
            if (newsCounter != 0) {
                msg.append(NLS.bind((String)Messages.CleanUpWizard_N_NEWS, (Object)newsCounter)).append("\n");
            }
            if (smCounter == 1) {
                msg.append(NLS.bind((String)Messages.CleanUpWizard_ONE_SEARCH, (Object)StringUtils.replaceAll((String)smNames.toString(), (String)"&", (String)"&&"))).append("\n");
            } else if (smCounter > 1) {
                msg.append(NLS.bind((String)Messages.CleanUpWizard_N_SEARCHES, (Object)smCounter, (Object)StringUtils.replaceAll((String)smNames.toString(), (String)"&", (String)"&&"))).append("\n");
            }
            ConfirmDialog dialog = new ConfirmDialog(this.getShell(), Messages.CleanUpWizard_CONFIRM_DELETE, Messages.CleanUpWizard_NO_UNDO, msg.toString(), null);
            if (dialog.open() != 0) {
                return false;
            }
        }
        if (bmCounter > 0) {
            OwlUI.getFeedViews();
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                IPreferenceScope preferences = Owl.getPreferenceService().getGlobalScope();
                boolean optimizeSearch = false;
                monitor.beginTask(Messages.CleanUpWizard_WAIT_CLEANUP, -1);
                ArrayList<IBookMark> bookmarks = new ArrayList<IBookMark>();
                for (CleanUpTask task : tasks) {
                    if (task instanceof BookMarkTask) {
                        bookmarks.add(((BookMarkTask)task).getMark());
                        continue;
                    }
                    if (task instanceof NewsTask) {
                        Collection<NewsReference> news = ((NewsTask)task).getNews();
                        ArrayList<INews> resolvedNews = new ArrayList<INews>(news.size());
                        for (NewsReference newsRef : news) {
                            INews resolvedNewsItem = newsRef.resolve();
                            if (resolvedNewsItem != null && resolvedNewsItem.isVisible()) {
                                resolvedNews.add(resolvedNewsItem);
                                continue;
                            }
                            CoreUtils.reportIndexIssue();
                        }
                        newsDao.setState(resolvedNews, INews.State.DELETED, false, false);
                        continue;
                    }
                    if (task instanceof DeleteOrphanedSearchMarkTask) {
                        List<ISearchMark> searches = ((DeleteOrphanedSearchMarkTask)task).getSearchMarks();
                        DynamicDAO.deleteAll(searches);
                        continue;
                    }
                    if (task instanceof DisableOrphanedNewsFiltersTask) {
                        List<ISearchFilter> filters = ((DisableOrphanedNewsFiltersTask)task).getFilters();
                        for (ISearchFilter filter : filters) {
                            filter.setEnabled(false);
                        }
                        DynamicDAO.saveAll(filters);
                        continue;
                    }
                    if (task instanceof OptimizeSearchTask) {
                        optimizeSearch = true;
                        continue;
                    }
                    if (task instanceof CleanUpIndexTask) {
                        preferences.putBoolean(DefaultPreferences.CLEAN_UP_INDEX, false);
                        Owl.getPersistenceService().getModelSearch().cleanUpOnNextStartup();
                        askForRestart.set(true);
                        continue;
                    }
                    if (!(task instanceof DefragDatabaseTask)) continue;
                    Owl.getPersistenceService().defragmentOnNextStartup();
                    askForRestart.set(true);
                }
                Controller.getDefault().getSavedSearchService().forceQuickUpdate();
                DynamicDAO.deleteAll(bookmarks);
                if (optimizeSearch) {
                    Owl.getPersistenceService().getModelSearch().optimize();
                }
                preferences.putBoolean(DefaultPreferences.CLEAN_UP_BM_BY_LAST_VISIT_STATE, operations.deleteFeedByLastVisit());
                preferences.putInteger(DefaultPreferences.CLEAN_UP_BM_BY_LAST_VISIT_VALUE, operations.getLastVisitDays());
                preferences.putBoolean(DefaultPreferences.CLEAN_UP_BM_BY_LAST_UPDATE_STATE, operations.deleteFeedByLastUpdate());
                preferences.putInteger(DefaultPreferences.CLEAN_UP_BM_BY_LAST_UPDATE_VALUE, operations.getLastUpdateDays());
                if (SyncUtils.hasSyncCredentials()) {
                    preferences.putBoolean(DefaultPreferences.CLEAN_UP_BM_BY_SYNCHRONIZATION, operations.deleteFeedsBySynchronization());
                }
                preferences.putBoolean(DefaultPreferences.CLEAN_UP_BM_BY_CON_ERROR, operations.deleteFeedsByConError());
                preferences.putBoolean(DefaultPreferences.CLEAN_UP_BM_BY_DUPLICATES, operations.deleteFeedsByDuplicates());
                preferences.putBoolean(DefaultPreferences.CLEAN_UP_NEWS_BY_AGE_STATE, operations.deleteNewsByAge());
                preferences.putInteger(DefaultPreferences.CLEAN_UP_NEWS_BY_AGE_VALUE, operations.getMaxNewsAge());
                preferences.putBoolean(DefaultPreferences.CLEAN_UP_NEWS_BY_COUNT_STATE, operations.deleteNewsByCount());
                preferences.putInteger(DefaultPreferences.CLEAN_UP_NEWS_BY_COUNT_VALUE, operations.getMaxNewsCountPerFeed());
                preferences.putBoolean(DefaultPreferences.CLEAN_UP_READ_NEWS_STATE, operations.deleteReadNews());
                preferences.putBoolean(DefaultPreferences.CLEAN_UP_NEVER_DEL_UNREAD_NEWS_STATE, operations.keepUnreadNews());
                preferences.putBoolean(DefaultPreferences.CLEAN_UP_NEVER_DEL_LABELED_NEWS_STATE, operations.keepLabeledNews());
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        if (askForRestart.get() && (restart = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.CleanUpWizard_RESTART_RSSOWL, (String)Messages.CleanUpWizard_RESTART_TO_CLEANUP))) {
            Controller.getDefault().restart();
        }
        return true;
    }

    public boolean needsProgressMonitor() {
        return true;
    }
}

