/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

public class CleanUpReminderDialog
extends TitleAreaDialog {
    private static CleanUpReminderDialog fVisibleInstance;
    private LocalResourceManager fResources;
    private IPreferenceScope fPreferences = Owl.getPreferenceService().getGlobalScope();

    public CleanUpReminderDialog(Shell parentShell) {
        super(parentShell);
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    public static CleanUpReminderDialog getVisibleInstance() {
        return fVisibleInstance;
    }

    public int open() {
        fVisibleInstance = this;
        return super.open();
    }

    public boolean close() {
        fVisibleInstance = null;
        this.fResources.dispose();
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.CleanUpReminderDialog_CLEANUP_REMINDER_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.CleanUpReminderDialog_CLEANUP_REMINDER);
        this.setTitleImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/cleanup_wiz.gif"));
        this.setMessage(Messages.CleanUpReminderDialog_REMINDER_MSG);
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(1, 5, 10));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label infoLabel = new Label(composite, 64);
        infoLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        infoLabel.setText(Messages.CleanUpReminderDialog_OPEN_CLEANUP_WIZARD);
        Composite controlsContainer = new Composite(composite, 0);
        controlsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        controlsContainer.setLayout((Layout)LayoutUtils.createGridLayout(3, 0, 0, 5, 0, false));
        ((GridLayout)controlsContainer.getLayout()).marginTop = 25;
        final Button reminderCheck = new Button(controlsContainer, 32);
        reminderCheck.setText(Messages.CleanUpReminderDialog_REMIND_EVERY);
        reminderCheck.setSelection(this.fPreferences.getBoolean(DefaultPreferences.CLEAN_UP_REMINDER_STATE));
        final Spinner reminderDaysValue = new Spinner(controlsContainer, 2048);
        reminderDaysValue.setMaximum(100);
        reminderDaysValue.setMinimum(1);
        reminderDaysValue.setSelection(this.fPreferences.getInteger(DefaultPreferences.CLEAN_UP_REMINDER_DAYS_VALUE));
        reminderDaysValue.setEnabled(reminderCheck.getSelection());
        reminderDaysValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpReminderDialog.this.fPreferences.putInteger(DefaultPreferences.CLEAN_UP_REMINDER_DAYS_VALUE, reminderDaysValue.getSelection());
            }
        });
        reminderCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                reminderDaysValue.setEnabled(reminderCheck.getSelection());
                CleanUpReminderDialog.this.fPreferences.putBoolean(DefaultPreferences.CLEAN_UP_REMINDER_STATE, reminderCheck.getSelection());
            }
        });
        Label reminderDaysLabel = new Label(controlsContainer, 0);
        reminderDaysLabel.setText(Messages.CleanUpReminderDialog_DAYS);
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        CleanUpReminderDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.YES_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.NO_LABEL, false);
    }

    protected int getShellStyle() {
        int style = 0x860 | CleanUpReminderDialog.getDefaultOrientation();
        return style;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        int maxWidth = this.convertHorizontalDLUsToPixels(320);
        int maxHeight = 500;
        Point requiredSize = shell.computeSize(-1, -1);
        shell.setSize(Math.min(maxWidth, requiredSize.x), Math.min(maxHeight, requiredSize.y));
        LayoutUtils.positionShell(shell);
    }
}

