/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.MergeResult;
import org.rssowl.core.internal.persist.Persistable;
import org.rssowl.core.persist.ISource;
import org.rssowl.core.util.MergeUtils;

public class Source
extends Persistable
implements ISource {
    private String fLink;
    private String fName;

    public Source() {
    }

    public Source(URI link) {
        if (link != null) {
            this.fLink = link.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source(ISource source) {
        ISource iSource = source;
        synchronized (iSource) {
            this.setLink(source.getLink());
            this.setName(source.getName());
        }
    }

    public synchronized void setName(String name) {
        this.fName = name;
    }

    public synchronized void setLink(URI link) {
        if (link != null) {
            this.fLink = link.toString();
        }
    }

    public synchronized String getName() {
        return this.fName;
    }

    public synchronized URI getLink() {
        return this.createURI(this.fLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object source) {
        if (this == source) {
            return true;
        }
        if (!(source instanceof Source)) {
            return false;
        }
        Object object = source;
        synchronized (object) {
            Source s = (Source)source;
            return (this.fLink == null ? s.fLink == null : this.getLink().equals(s.getLink())) && (this.fName == null ? s.fName == null : this.fName.equals(s.fName));
        }
    }

    public synchronized int hashCode() {
        int result = 1;
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + (this.fLink == null ? 0 : this.fLink.hashCode());
        return result;
    }

    public synchronized String toString() {
        return String.valueOf(super.toString()) + "Link = " + this.fLink + ", Name = " + this.fName + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MergeResult merge(ISource objectToMerge) {
        Assert.isNotNull((Object)objectToMerge);
        ISource iSource = objectToMerge;
        synchronized (iSource) {
            boolean updated = !MergeUtils.equals(this.fName, objectToMerge.getName());
            this.fName = objectToMerge.getName();
            boolean bl = !MergeUtils.equals(this.getLink(), objectToMerge.getLink());
            this.setLink(objectToMerge.getLink());
            MergeResult mergeResult = new MergeResult();
            if (updated |= bl) {
                mergeResult.addUpdatedObject(this);
            }
            return mergeResult;
        }
    }
}

