/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.interpreter.BasicInterpreter;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IGuid;
import org.rssowl.core.persist.IImage;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.ISource;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;

public class AtomInterpreter
extends BasicInterpreter {
    private int fNewsCounter;

    public void interpret(Document document, IFeed feed) {
        Element root = document.getRootElement();
        this.setDefaultNamespaceUri(root.getNamespace().getURI());
        this.setRootElementName(root.getName());
        feed.setFormat("Atom 1.0");
        this.processFeed(root, feed);
    }

    private void processFeed(Element element, IFeed feed) {
        List attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            String name = attribute.getName();
            if (this.processAttributeExtern(attribute, feed)) continue;
            if ("version".equals(name)) {
                feed.setFormat(this.buildFormat("Atom", attribute.getValue()));
                continue;
            }
            if (!"lang".equals(name)) continue;
            feed.setLanguage(attribute.getValue());
        }
        List channelChildren = element.getChildren();
        for (Element child : channelChildren) {
            URI uri;
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, feed)) continue;
            if ("title".equals(name)) {
                feed.setTitle(this.getContent(child));
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("tagline".equals(name) || "subtitle".equals(name)) {
                feed.setDescription(this.getContent(child));
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("generator".equals(name)) {
                feed.setGenerator(this.getContent(child));
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("copyright".equals(name) || "rights".equals(name)) {
                feed.setCopyright(this.getContent(child));
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("logo".equals(name)) {
                IImage image = Owl.getModelFactory().createImage(feed);
                uri = URIUtils.createURI(child.getText());
                if (uri != null) {
                    image.setLink(uri);
                }
                this.processNamespaceAttributes(child, image);
                continue;
            }
            if ("modified".equals(name) || "updated".equals(name)) {
                feed.setLastModifiedDate(DateUtils.parseDate(child.getText()));
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("link".equals(name)) {
                String rel = child.getAttributeValue("rel");
                if ("alternate".equals(rel) && (uri = URIUtils.createURI(child.getAttributeValue("href"))) != null) {
                    feed.setHomepage(uri);
                }
                this.processNamespaceAttributes(child, feed);
                continue;
            }
            if ("entry".equals(name)) {
                this.processEntry(child, feed);
                continue;
            }
            if ("category".equals(name)) {
                this.processCategory(child, feed);
                continue;
            }
            if (!"author".equals(name)) continue;
            this.processAuthor(child, feed);
        }
    }

    private void processEntry(Element element, IFeed feed) {
        INews news = Owl.getModelFactory().createNews(null, feed, new Date(System.currentTimeMillis() - (long)(this.fNewsCounter++ * 1)));
        news.setBase(feed.getBase());
        this.processNamespaceAttributes(element, news);
        List newsChilds = element.getChildren();
        for (Element child : newsChilds) {
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, news)) continue;
            if ("title".equals(name)) {
                news.setTitle(this.getContent(child));
                this.processNamespaceAttributes(child, news);
                continue;
            }
            if ("content".equals(name) || "summary".equals(name)) {
                news.setDescription(this.getContent(child));
                this.processNamespaceAttributes(child, news);
                continue;
            }
            if ("modified".equals(name) || "updated".equals(name)) {
                news.setModifiedDate(DateUtils.parseDate(child.getText()));
                this.processNamespaceAttributes(child, news);
                continue;
            }
            if ("issued".equals(name) || "created".equals(name) || "published".equals(name)) {
                news.setPublishDate(DateUtils.parseDate(child.getText()));
                this.processNamespaceAttributes(child, news);
                continue;
            }
            if ("id".equals(name)) {
                IGuid guid = Owl.getModelFactory().createGuid(news, child.getText(), null);
                this.processNamespaceAttributes(child, guid);
                continue;
            }
            if ("link".equals(name)) {
                String rel = child.getAttributeValue("rel");
                if (rel == null || "alternate".equals(rel)) {
                    URI uri = URIUtils.createURI(child.getAttributeValue("href"));
                    if (uri != null) {
                        news.setLink(uri);
                    }
                    this.processNamespaceAttributes(child, news);
                    continue;
                }
                if (!"enclosure".equals(rel)) continue;
                URI attachmentUri = URIUtils.createURI(child.getAttributeValue("href"));
                String attachmentType = child.getAttributeValue("type");
                int attachmentLength = StringUtils.stringToInt(child.getAttributeValue("length"));
                if (attachmentUri == null || CoreUtils.hasAttachment(news, attachmentUri)) continue;
                IAttachment attachment = Owl.getModelFactory().createAttachment(null, news);
                attachment.setLink(attachmentUri);
                if (StringUtils.isSet(attachmentType)) {
                    attachment.setType(attachmentType);
                }
                if (attachmentLength != -1) {
                    attachment.setLength(attachmentLength);
                }
                this.processNamespaceAttributes(child, attachment);
                continue;
            }
            if ("category".equals(name)) {
                this.processCategory(child, news);
                continue;
            }
            if ("source".equals(name)) {
                this.processSource(child, news);
                continue;
            }
            if (!"author".equals(name)) continue;
            this.processAuthor(child, news);
        }
    }

    private String getContent(Element element) {
        String type = element.getAttributeValue("type");
        if ("xhtml".equals(type) || "application/xhtml+xml".equals(type)) {
            List children = element.getChildren();
            for (Element contentChild : children) {
                String name = contentChild.getName();
                if (!"div".equals(name)) continue;
                XMLOutputter out = new XMLOutputter();
                StringWriter writer = new StringWriter();
                try {
                    out.output(contentChild.getContent(), (Writer)writer);
                    writer.close();
                }
                catch (IOException iOException) {}
                String content = writer.toString();
                if (content.contains("<![CDATA[")) {
                    content = StringUtils.replaceAll(content, "<![CDATA[", "");
                    content = StringUtils.replaceAll(content, "]]>", "");
                }
                return content;
            }
        }
        return element.getText();
    }

    private void processSource(Element element, INews news) {
        ISource source = Owl.getModelFactory().createSource(news);
        this.processNamespaceAttributes(element, source);
        List sourceChilds = element.getChildren();
        for (Element child : sourceChilds) {
            URI uri;
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, source)) continue;
            if ("title".equals(name)) {
                source.setName(child.getText());
                this.processNamespaceAttributes(child, source);
                continue;
            }
            if ("link".equals(name)) {
                uri = URIUtils.createURI(child.getText());
                if (uri != null) {
                    source.setLink(uri);
                }
                this.processNamespaceAttributes(child, source);
                continue;
            }
            if (!"id".equals(name) || source.getLink() != null) continue;
            uri = URIUtils.createURI(child.getText());
            if (uri != null) {
                source.setLink(uri);
            }
            this.processNamespaceAttributes(child, source);
        }
    }

    private void processCategory(Element element, IEntity type) {
        ICategory category = Owl.getModelFactory().createCategory(null, type);
        List categoryAttributes = element.getAttributes();
        for (Attribute attribute : categoryAttributes) {
            String name = attribute.getName().toLowerCase();
            if (this.processAttributeExtern(attribute, category)) continue;
            if ("term".equals(name)) {
                category.setDomain(attribute.getValue());
                if (category.getName() != null) continue;
                category.setName(attribute.getValue());
                continue;
            }
            if (!"label".equals(name)) continue;
            category.setName(attribute.getValue());
        }
    }

    private void processAuthor(Element element, IPersistable type) {
        IPerson person = Owl.getModelFactory().createPerson(null, type);
        this.processNamespaceAttributes(element, person);
        List personChilds = element.getChildren();
        for (Element child : personChilds) {
            URI uri;
            String name = child.getName().toLowerCase();
            if (this.processElementExtern(child, person)) continue;
            if ("name".equals(name)) {
                person.setName(child.getText());
                this.processNamespaceAttributes(child, person);
                continue;
            }
            if ("email".equals(name)) {
                uri = URIUtils.createURI(child.getText());
                if (uri != null) {
                    person.setEmail(uri);
                }
                this.processNamespaceAttributes(child, person);
                continue;
            }
            if (!"uri".equals(name)) continue;
            uri = URIUtils.createURI(child.getText());
            if (uri != null) {
                person.setUri(uri);
            }
            this.processNamespaceAttributes(child, person);
        }
    }
}

