/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui.nav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.on.embedded.manager.ResourceManager;
import org.jboss.on.embedded.manager.ResourceManagerFactory;
import org.jboss.on.embedded.ui.SummaryAction;
import org.jboss.on.embedded.ui.nav.JONTreeNode;
import org.jboss.on.embedded.ui.nav.NonSingletonResourceTypeTreeNode;
import org.jboss.on.embedded.ui.nav.ResourceTypeTreeNode;
import org.jboss.on.embedded.ui.nav.SingletonResourceTypeTreeNode;
import org.jboss.on.embedded.ui.nav.SubCategoryTreeNode;
import org.jboss.on.embedded.ui.nav.TreeNodeWithResourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceSubCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.richfaces.model.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTreeNode
implements JONTreeNode {
    private JONTreeNode parent;
    protected Map<Object, JONTreeNode> childrenMap;
    private String key;
    private static final AtomicInteger nodeKey = new AtomicInteger();

    public BaseTreeNode(String key) {
        this.key = key;
    }

    private Map<Object, JONTreeNode> getChildrenMap() {
        if (this.childrenMap == null) {
            this.childrenMap = new LinkedHashMap<Object, JONTreeNode>();
            this.initChildrenMap();
        }
        return this.childrenMap;
    }

    protected abstract void initChildrenMap();

    @Override
    public abstract SummaryAction.SummaryActionOutcome getSummaryActionOutcome(SummaryAction var1);

    @Override
    public void reInitializeChildrenMap() {
        if (this.childrenMap != null) {
            this.childrenMap.clear();
            this.childrenMap = null;
        }
        this.getChildrenMap();
    }

    public Object getData() {
        return this;
    }

    public void setData(Object object) {
    }

    public boolean isLeaf() {
        return this.getChildrenMap().isEmpty();
    }

    public Iterator<Map.Entry<Object, JONTreeNode>> getChildren() {
        return this.getChildrenMap().entrySet().iterator();
    }

    @Override
    public Collection<JONTreeNode> getChildNodes() {
        return this.getChildrenMap().values();
    }

    public List<JONTreeNode> getChildNodesAsList() {
        return new ArrayList<JONTreeNode>(this.getChildNodes());
    }

    public JONTreeNode getChild(Object key) {
        return this.getChildrenMap().get(key);
    }

    public void addChild(BaseTreeNode child) {
        this.addChild(child.getKey(), child);
    }

    private String getKey() {
        return this.key;
    }

    public void addChild(Object key, TreeNode child) {
        child.setParent((TreeNode)this);
        this.getChildrenMap().put(key, (JONTreeNode)child);
    }

    public void removeChild(Object key) {
        JONTreeNode treeNode = this.getChildrenMap().remove(key);
        if (treeNode != null) {
            treeNode.setParent(null);
        }
    }

    @Override
    public JONTreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode treeNode) {
        this.parent = (JONTreeNode)treeNode;
    }

    public static String getUniqueKey() {
        return String.valueOf(nodeKey.incrementAndGet());
    }

    protected void addChildResourceTypeNode(@NotNull ResourceType resourceType, @NotNull Resource parentResource) {
        this.addChildResourceTypeNode(resourceType, parentResource, true);
    }

    protected void addChildResourceTypeNodeWithSubCategory(@NotNull ResourceType resourceType, @NotNull Resource parentResource) {
        this.addChildResourceTypeNode(resourceType, parentResource, false);
    }

    private void addChildResourceTypeNode(@NotNull ResourceType resourceType, @NotNull Resource parentResource, boolean ignoreSubCategorizedResources) {
        if (resourceType == null) {
            throw new IllegalArgumentException("ResourceType cannot be null");
        }
        if (ignoreSubCategorizedResources && resourceType.getSubCategory() != null) {
            return;
        }
        Set<Resource> resources = this.getResourceManager().getResources(resourceType, parentResource);
        if (resourceType.isSingleton() && !resources.isEmpty()) {
            if (resources.size() > 1) {
                throw new IllegalArgumentException("ResourceType [" + resourceType + "] has more than one resource " + "associated with it, yet it is specified as a Singleton");
            }
            this.addChild(new SingletonResourceTypeTreeNode(BaseTreeNode.getUniqueKey(), resourceType, resources.iterator().next(), parentResource));
        } else if (!(resourceType.isSingleton() || resources.isEmpty() && !resourceType.isCreatable())) {
            this.addChild(new NonSingletonResourceTypeTreeNode(BaseTreeNode.getUniqueKey(), resourceType, parentResource));
        }
    }

    protected void addChildResourceTypeOrSubCategoryNodes(@NotNull ResourceType resourceType, @NotNull Resource parentResource) {
        if (resourceType == null) {
            throw new IllegalArgumentException("ResourceType cannot be null");
        }
        Set childResourceTypes = resourceType.getChildResourceTypes();
        for (ResourceType childResourceType : childResourceTypes) {
            this.addChildResourceTypeNode(childResourceType, parentResource);
        }
        List subCategories = resourceType.getChildSubCategories();
        TreeSet sortedSubCategories = new TreeSet(subCategories);
        for (ResourceSubCategory subCategory : sortedSubCategories) {
            if (subCategory.getChildSubCategories().isEmpty() && subCategory.findTaggedResourceTypes().isEmpty()) continue;
            this.addChild(new SubCategoryTreeNode(BaseTreeNode.getUniqueKey(), subCategory, parentResource));
        }
    }

    public ResourceManager getResourceManager() {
        return ResourceManagerFactory.resourceManager();
    }

    @Override
    @Nullable
    public JONTreeNode findNode(@Nullable String path) {
        if (path != null && !path.equals("")) {
            return this.findNode(this, new PathBasedNodeMatcher(path));
        }
        return null;
    }

    @Nullable
    public JONTreeNode findNodeByTypeName(@Nullable String typeName) {
        if (typeName != null && !typeName.equals("")) {
            return this.findNode(this, new ResourceTypeNameNodeMatcher(typeName));
        }
        return null;
    }

    public ResourceTypeTreeNode findNodeByType(@NotNull ResourceType resourceType) {
        if (resourceType != null) {
            return (ResourceTypeTreeNode)this.findNode(this, new ResourceTypeNodeMatcher(resourceType));
        }
        return null;
    }

    private JONTreeNode findNode(JONTreeNode currentNode, NodeMatcher matcher) {
        JONTreeNode resultNode = null;
        if (matcher.matchesNode(currentNode)) {
            resultNode = currentNode;
        } else {
            JONTreeNode child;
            Iterator<JONTreeNode> i$ = currentNode.getChildNodes().iterator();
            while (i$.hasNext() && (resultNode = this.findNode(child = i$.next(), matcher)) == null) {
            }
        }
        return resultNode;
    }

    private class ResourceTypeNodeMatcher
    implements NodeMatcher {
        private ResourceType resourceType;

        public ResourceTypeNodeMatcher(ResourceType resourceType) {
            if (resourceType == null) {
                throw new IllegalArgumentException("ResourceType cannot be null");
            }
            this.resourceType = resourceType;
        }

        public boolean matchesNode(JONTreeNode node) {
            boolean result = false;
            if (node instanceof TreeNodeWithResourceType) {
                TreeNodeWithResourceType nodeWithResourceType = (TreeNodeWithResourceType)((Object)node);
                result = this.resourceType.equals((Object)nodeWithResourceType.getResourceType());
            }
            return result;
        }
    }

    private class ResourceTypeNameNodeMatcher
    implements NodeMatcher {
        private String resourceTypeName;

        public ResourceTypeNameNodeMatcher(String resourceTypeName) {
            this.resourceTypeName = resourceTypeName;
        }

        public boolean matchesNode(JONTreeNode node) {
            boolean result = false;
            if (node instanceof TreeNodeWithResourceType) {
                TreeNodeWithResourceType nodeWithResourceType = (TreeNodeWithResourceType)((Object)node);
                result = this.resourceTypeName.equals(nodeWithResourceType.getResourceType().getName());
            }
            return result;
        }
    }

    private class PathBasedNodeMatcher
    implements NodeMatcher {
        private String path;

        public PathBasedNodeMatcher(String path) {
            this.path = path;
        }

        public boolean matchesNode(JONTreeNode node) {
            return this.path.equals(node.getPath());
        }
    }

    private static interface NodeMatcher {
        public boolean matchesNode(JONTreeNode var1);
    }
}

