/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.sort;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.deployers.plugins.sort.DeployerSorter;
import org.jboss.deployers.spi.Ordered;
import org.jboss.deployers.spi.deployer.Deployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependenciesTopologicalDeployerSorter
implements DeployerSorter {
    @Override
    public List<Deployer> sortDeployers(List<Deployer> registeredDeployers, Deployer newDeployer) {
        return this.createOrientedGraph(registeredDeployers, newDeployer).sort();
    }

    private Graph createOrientedGraph(List<Deployer> deployers, Deployer newDeployer) {
        Graph graph = new Graph();
        for (Deployer deployer : deployers) {
            graph.addVertex(deployer);
        }
        graph.addVertex(newDeployer);
        graph.createEdges();
        return graph;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Graph {
        private Map<String, Dependency> dependencies = new HashMap<String, Dependency>();
        private Set<Vertex> vertices = new HashSet<Vertex>();

        private Graph() {
        }

        public void addVertex(Deployer deployer) {
            Dependency dependency;
            HashSet<String> inputs = new HashSet<String>();
            inputs.addAll(deployer.getInputs());
            HashSet<String> outputs = new HashSet<String>();
            outputs.addAll(deployer.getOutputs());
            Set<String> intersection = this.getIntersection(inputs, outputs);
            Vertex vertex = new Vertex(deployer);
            this.vertices.add(vertex);
            for (String in : inputs) {
                dependency = this.getDependency(in);
                dependency.consumers.add(vertex);
            }
            for (String inOut : intersection) {
                dependency = this.getDependency(inOut);
                dependency.modifiers.add(vertex);
            }
            for (String out : outputs) {
                dependency = this.getDependency(out);
                dependency.producers.add(vertex);
            }
        }

        public List<Deployer> sort() {
            LinkedList<Deployer> retVal = new LinkedList<Deployer>();
            List<Vertex> roots = this.getRoots();
            Collections.sort(roots, Ordered.COMPARATOR);
            while (!roots.isEmpty()) {
                Vertex root = roots.remove(0);
                retVal.add(root.getDeployer());
                if (!root.hasConsumers()) continue;
                TreeSet<Vertex> nextLevel = new TreeSet<Vertex>(Ordered.COMPARATOR);
                for (Vertex consumer : root.consumers) {
                    consumer.decrementDegree();
                    if (consumer.hasProducers()) continue;
                    this.remove(consumer);
                    nextLevel.add(consumer);
                }
                roots.addAll(nextLevel);
            }
            if (this.vertices.size() > 0) {
                throw new IllegalStateException("Cycle detected in subgraph: " + this.vertices);
            }
            return retVal;
        }

        private Set<String> getIntersection(Set<String> inputs, Set<String> outputs) {
            HashSet<String> intersection = new HashSet<String>();
            for (String input : inputs) {
                for (String output : outputs) {
                    if (!input.equals(output)) continue;
                    intersection.add(input);
                }
            }
            inputs.removeAll(intersection);
            outputs.removeAll(intersection);
            return intersection;
        }

        private Dependency getDependency(String name) {
            if (this.dependencies.containsKey(name)) {
                return this.dependencies.get(name);
            }
            Dependency newDependency = new Dependency();
            this.dependencies.put(name, newDependency);
            return newDependency;
        }

        private void createEdges() {
            for (String dependencyName : this.dependencies.keySet()) {
                boolean hasModifiers;
                Dependency dependency = this.dependencies.get(dependencyName);
                boolean bl = hasModifiers = dependency.modifiers.size() > 0;
                if (hasModifiers) {
                    this.createEdges(dependency.producers, dependency.modifiers);
                    this.createEdges(dependency.modifiers, dependency.consumers);
                    continue;
                }
                this.createEdges(dependency.producers, dependency.consumers);
            }
        }

        private void createEdges(List<Vertex> producers, List<Vertex> consumers) {
            for (Vertex producer : producers) {
                for (Vertex consumer : consumers) {
                    producer.addConsumer(consumer);
                    consumer.incrementDegree();
                }
            }
        }

        private List<Vertex> getRoots() {
            LinkedList<Vertex> retVal = new LinkedList<Vertex>();
            Iterator<Vertex> i = this.vertices.iterator();
            while (i.hasNext()) {
                Vertex current = i.next();
                if (current.hasProducers()) continue;
                retVal.add(current);
                i.remove();
            }
            return retVal;
        }

        private void remove(Vertex v) {
            this.vertices.remove(v);
        }

        private static class Dependency {
            private List<Vertex> producers = new LinkedList<Vertex>();
            private List<Vertex> modifiers = new LinkedList<Vertex>();
            private List<Vertex> consumers = new LinkedList<Vertex>();

            private Dependency() {
            }
        }

        private static class Vertex
        implements Ordered {
            private Deployer deployer;
            private int inDegree;
            private List<Vertex> consumers = new LinkedList<Vertex>();

            public Vertex(Deployer deployer) {
                this.deployer = deployer;
            }

            public void incrementDegree() {
                ++this.inDegree;
            }

            public void decrementDegree() {
                --this.inDegree;
            }

            public boolean hasProducers() {
                return this.inDegree > 0;
            }

            public void addConsumer(Vertex v) {
                this.consumers.add(v);
            }

            public boolean hasConsumers() {
                return this.consumers.size() > 0;
            }

            public Deployer getDeployer() {
                return this.deployer;
            }

            public int getRelativeOrder() {
                return this.deployer.getRelativeOrder();
            }

            public void setRelativeOrder(int order) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return this.deployer.toString();
            }
        }
    }
}

