/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.annotations.plugins;

import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.scanning.annotations.plugins.DefaultAnnotationRepository;
import org.jboss.scanning.annotations.plugins.GenericAnnotationVisitor;
import org.jboss.scanning.annotations.spi.AnnotationIndex;
import org.jboss.scanning.plugins.helpers.ClassResourceOwnerFinder;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;
import org.jboss.scanning.plugins.visitor.ErrorHandler;
import org.jboss.scanning.plugins.visitor.IntrospectionReflectProvider;
import org.jboss.scanning.plugins.visitor.ReflectProvider;
import org.jboss.scanning.spi.helpers.AbstractClassLoadingScanningPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsScanningPlugin
extends AbstractClassLoadingScanningPlugin<DefaultAnnotationRepository, AnnotationIndex> {
    private final DefaultAnnotationRepository repository;
    private final GenericAnnotationVisitor visitor;

    public AnnotationsScanningPlugin(ClassLoader cl) {
        this(IntrospectionReflectProvider.INSTANCE, ClassResourceOwnerFinder.INSTANCE, cl, null);
    }

    public AnnotationsScanningPlugin(ReflectProvider provider, ResourceOwnerFinder finder, ClassLoader cl, ErrorHandler handler) {
        this.repository = new DefaultAnnotationRepository(cl);
        this.visitor = new GenericAnnotationVisitor(provider, finder, this.repository);
        this.visitor.setErrorHandler(handler);
    }

    protected DefaultAnnotationRepository doCreateHandle() {
        return this.repository;
    }

    protected ClassLoader getClassLoader() {
        return this.repository.getClassLoader();
    }

    public void cleanupHandle(AnnotationIndex handle) {
        if (handle instanceof DefaultAnnotationRepository) {
            ((DefaultAnnotationRepository)DefaultAnnotationRepository.class.cast(handle)).cleanup();
        }
    }

    public Class<AnnotationIndex> getHandleInterface() {
        return AnnotationIndex.class;
    }

    public ResourceFilter getFilter() {
        return this.visitor.getFilter();
    }

    public void visit(ResourceContext resource) {
        this.visitor.visit(resource);
    }
}

