/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.marshalling.NioByteInput;
import org.jboss.remoting3.remote.InboundRequest;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.xnio.Pool;
import org.jboss.xnio.log.Logger;

final class InboundRequestInputHandler
implements NioByteInput.InputHandler {
    private final int rid;
    private final InboundRequest inboundRequest;
    private static final Logger log = Loggers.main;

    public InboundRequestInputHandler(InboundRequest inboundRequest, int rid) {
        this.inboundRequest = inboundRequest;
        this.rid = rid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge() throws IOException {
        RemoteConnectionHandler connectionHandler = this.inboundRequest.getRemoteConnectionHandler();
        Pool<ByteBuffer> bufferPool = connectionHandler.getBufferPool();
        ByteBuffer buffer = (ByteBuffer)bufferPool.allocate();
        try {
            buffer.putInt(0);
            buffer.put((byte)50);
            buffer.putInt(this.rid);
            buffer.flip();
            RemoteConnection connection = connectionHandler.getRemoteConnection();
            connection.sendBlocking(buffer, true);
        }
        catch (IOException e) {
            log.trace((Throwable)e, "Failed to acknowledge chunk for %s", (Object)this);
        }
        finally {
            bufferPool.free((Object)buffer);
        }
    }

    public void close() throws IOException {
    }

    public String toString() {
        return "Inbound request input handler for request ID " + this.rid;
    }
}

