/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist.bytecode;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
    }

    static Constructor<?>[] getDeclaredConstructors(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredConstructors();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Constructor<?>[]>(){

            @Override
            public Constructor<?>[] run() {
                return clazz.getDeclaredConstructors();
            }
        });
    }

    static Method[] getDeclaredMethods(final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredMethods();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        });
    }

    static void setAccessible(final AccessibleObject member) {
        if (System.getSecurityManager() == null) {
            member.setAccessible(true);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    member.setAccessible(true);
                    return null;
                }
            });
        }
    }

    static Object invoke(final Method method, final Object target, final Object ... args) throws IllegalAccessException, InvocationTargetException {
        if (System.getSecurityManager() == null) {
            return method.invoke(target, args);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return method.invoke(target, args);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof IllegalAccessException) {
                throw (IllegalAccessException)e.getCause();
            }
            if (e.getCause() instanceof InvocationTargetException) {
                throw (InvocationTargetException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    static Field getDeclaredField(final Class<?> clazz, final String name) throws NoSuchFieldException {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredField(name);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                @Override
                public Field run() throws Exception {
                    return clazz.getDeclaredField(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchFieldException) {
                throw (NoSuchFieldException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    static Method getDeclaredMethod(final Class<?> clazz, final String name, final Class<?> ... parameters) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredMethod(name, parameters);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz.getDeclaredMethod(name, parameters);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchFieldException) {
                throw (NoSuchMethodException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    static Constructor<?> getDeclaredConstructor(final Class<?> clazz, final Class<?> ... parameters) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return clazz.getDeclaredConstructor(parameters);
        }
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws Exception {
                    return clazz.getDeclaredConstructor(parameters);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchFieldException) {
                throw (NoSuchMethodException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetContextClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        static final GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();

        GetContextClassLoaderAction() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

