/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.annotation.Inherited;
import java.util.HashMap;
import java.util.Map;
import javassist.CtClass;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavassistInheritableAnnotationHolder
extends JavassistAnnotatedInfo {
    private static final long serialVersionUID = -714018976926313160L;
    private static final String INHERITED_NAME = Inherited.class.getName();
    protected volatile Map<String, AnnotationValue> allAnnotations;
    protected volatile AnnotationValue[] allAnnotationsArray = NOT_CONFIGURED;
    protected boolean initialized;
    protected final CtClass ctClass;

    public JavassistInheritableAnnotationHolder(CtClass ctClass, AnnotationHelper annotationHelper) {
        super(annotationHelper);
        this.ctClass = ctClass;
    }

    @Override
    public AnnotationValue[] getAnnotations() {
        if (this.allAnnotationsArray == NOT_CONFIGURED) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.ctClass));
        }
        return this.allAnnotationsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AnnotationValue[] getAnnotations(Object obj) {
        if (!this.initialized) {
            JavassistInheritableAnnotationHolder javassistInheritableAnnotationHolder = this;
            synchronized (javassistInheritableAnnotationHolder) {
                if (!this.initialized) {
                    AnnotationValue[] allAnnotations = this.annotationHelper.getAnnotations(obj);
                    this.allAnnotationsArray = allAnnotations;
                    this.setupAnnotations(allAnnotations);
                    this.initialized = true;
                }
            }
        }
        return this.allAnnotationsArray;
    }

    @Override
    public AnnotationValue getAnnotation(String name) {
        this.getAnnotations();
        return this.allAnnotations.get(name);
    }

    @Override
    public boolean isAnnotationPresent(String name) {
        this.getAnnotations();
        return this.allAnnotations.containsKey(name);
    }

    @Override
    public void setupAnnotations(AnnotationValue[] annotations) {
        ClassInfo superHolder = this.getSuperHolder();
        AnnotationValue[] superAllAnnotations = superHolder != null ? superHolder.getAnnotations() : null;
        this.allAnnotations = new HashMap<String, AnnotationValue>(annotations.length);
        if (annotations != null && annotations.length > 0) {
            int i;
            this.annotationMap = new HashMap(annotations.length);
            this.annotationsArray = annotations;
            for (i = 0; i < annotations.length; ++i) {
                this.annotationMap.put(annotations[i].getAnnotationType().getName(), annotations[i]);
            }
            if (superHolder != null && superAllAnnotations != null && superAllAnnotations.length != 0) {
                for (i = 0; i < superAllAnnotations.length; ++i) {
                    AnnotationValue av = superAllAnnotations[i];
                    if (!av.getAnnotationType().isAnnotationPresent(INHERITED_NAME)) continue;
                    this.allAnnotations.put(av.getAnnotationType().getName(), av);
                }
            } else {
                this.allAnnotationsArray = this.annotationsArray;
            }
            for (i = 0; i < annotations.length; ++i) {
                this.allAnnotations.put(annotations[i].getAnnotationType().getName(), annotations[i]);
            }
        } else if (superHolder != null && superAllAnnotations.length > 0) {
            for (int i = 0; i < superAllAnnotations.length; ++i) {
                AnnotationValue av = superAllAnnotations[i];
                if (!av.getAnnotationType().isAnnotationPresent(INHERITED_NAME)) continue;
                this.allAnnotations.put(av.getAnnotationType().getName(), av);
            }
        }
        this.allAnnotationsArray = this.allAnnotations.values().toArray(new AnnotationValue[this.allAnnotations.size()]);
    }

    protected Map<String, AnnotationValue> getAllAnnotations() {
        if (this.allAnnotations == null) {
            this.setupAnnotations(this.annotationHelper.getAnnotations(this.ctClass));
        }
        return this.allAnnotations;
    }

    public abstract ClassInfo getSuperHolder();
}

