/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import java.lang.reflect.Method;
import org.jboss.weld.util.bytecode.DescriptorUtils;
import org.jboss.weld.util.bytecode.MethodInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticMethodInformation
implements MethodInformation {
    private final String name;
    private final String descriptor;
    private final String[] parameterTypes;
    private final String returnType;
    private final String declaringClass;

    public StaticMethodInformation(String name, Class<?>[] parameterTypes, Class<?> returnType, String declaringClass) {
        this.name = name;
        this.parameterTypes = DescriptorUtils.getParameterTypes(parameterTypes);
        this.returnType = DescriptorUtils.classToStringRepresentation(returnType);
        this.declaringClass = declaringClass;
        StringBuilder builder = new StringBuilder("(");
        for (String p : this.parameterTypes) {
            builder.append(p);
        }
        builder.append(')');
        builder.append(this.returnType);
        this.descriptor = builder.toString();
    }

    public StaticMethodInformation(String name, String[] parameterTypes, String returnType, String declaringClass) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.declaringClass = declaringClass;
        StringBuilder builder = new StringBuilder("(");
        for (String p : this.parameterTypes) {
            builder.append(p);
        }
        builder.append(')');
        builder.append(returnType);
        this.descriptor = builder.toString();
    }

    @Override
    public String getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public Method getMethod() {
        return null;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

