/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact.maven;

import java.io.IOException;
import java.net.URI;
import org.jboss.profileservice.repository.artifact.AbstractArtifactRepository;
import org.jboss.profileservice.repository.artifact.maven.MavenArtifactId;
import org.jboss.profileservice.repository.artifact.maven.MavenArtifactMetaData;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;
import org.jboss.vfs.VirtualFile;

public abstract class AbstractMavenArtifactRepository
extends AbstractArtifactRepository<MavenArtifactId> {
    private static final char GROUP_SEPARATOR = '.';
    private static final char ARTIFACT_SEPARATOR = '-';

    public AbstractMavenArtifactRepository(ArtifactRepositoryId identifier, URI root) throws IOException {
        super(identifier, root);
    }

    protected VirtualFile getGroupRoot(MavenArtifactId artifactId) {
        String[] groups = artifactId.getGroupId().split("\\.");
        VirtualFile child = this.getRepositoryRoot();
        for (String group : groups) {
            child = child.getChild(group);
        }
        return child;
    }

    protected VirtualFile getArtifactIdRoot(MavenArtifactId artifactId) {
        return this.getGroupRoot(artifactId).getChild(artifactId.getArtifactId());
    }

    protected VirtualFile resolveArtifactFile(MavenArtifactMetaData artifact) {
        VirtualFile artifactRoot = this.getArtifactIdRoot(artifact).getChild(artifact.getVersion().toString());
        return artifactRoot.getChild(this.createArtifactName(artifact));
    }

    String createArtifactName(MavenArtifactMetaData artifact) {
        StringBuilder builder = new StringBuilder();
        builder.append(artifact.getArtifactId());
        builder.append('-').append(artifact.getVersion().toString());
        if (artifact.getClassifier() != null) {
            builder.append('-').append(artifact.getClassifier());
        }
        builder.append('.').append(artifact.getPackagingType());
        return builder.toString();
    }

    String getRelativePath(MavenArtifactId artifact) throws IOException {
        return this.getArtifactFile(artifact).getPathNameRelativeTo(this.getRepositoryRoot());
    }
}

