/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.profile;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.logging.Logger;
import org.jboss.profileservice.profile.AbstractScanningProfile;
import org.jboss.profileservice.repository.artifact.file.FileArtifactId;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.VirtualDeploymentRepositoryExt;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;

public class MutableScanningProfile
extends AbstractScanningProfile
implements MutableProfile,
VirtualDeploymentRepositoryExt {
    private static final Logger log = Logger.getLogger((String)"org.jboss.profileservice.profile");
    private volatile boolean enableChecks = true;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public MutableScanningProfile(ProfileKey key, VirtualDeploymentRepository repository) {
        super(key, repository);
    }

    protected boolean isModificationCheckEnabled() {
        return this.enableChecks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeployment(ProfileDeployment deployment) throws Exception {
        if (deployment == null) {
            throw new IllegalArgumentException("null deployment");
        }
        this.lockWrite();
        try {
            FileArtifactId artifactId = this.getArtifactMetaData(deployment);
            if (!deployment.getDeploymentInfo().isLocked()) {
                this.getArtifactRepository().getArtifact((ArtifactId)artifactId);
            }
            this.internalAddDeployment(deployment, artifactId);
        }
        finally {
            this.unlockWrite();
        }
    }

    public void enableModifiedDeploymentChecks(boolean flag) {
        this.enableChecks = flag;
    }

    public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileDeployment removeDeployment(String name) throws NoSuchDeploymentException, Exception {
        if (name == null) {
            throw new IllegalArgumentException("null deployment name");
        }
        this.lockWrite();
        try {
            ProfileDeployment profileDeployment = this.internalRemoveDeployment(name);
            return profileDeployment;
        }
        finally {
            this.unlockWrite();
        }
    }

    public boolean isMutable() {
        return true;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    protected void lockRead() {
        this.lock.readLock().lock();
    }

    protected void unlockRead() {
        this.lock.readLock().unlock();
    }

    protected void lockWrite() {
        this.lock.writeLock().lock();
    }

    protected void unlockWrite() {
        this.lock.writeLock().unlock();
    }
}

