/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.dependency;

import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.plugins.dependency.KernelControllerContextActions;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.dependency.ProfileActivationService;
import org.jboss.profileservice.dependency.ProfileControllerContextActions;
import org.jboss.profileservice.deployment.ProfileDeployerPlugin;
import org.jboss.profileservice.repository.ProfileMetaDataContext;
import org.jboss.profileservice.resolver.ProfileRequirementResolutionContext;
import org.jboss.profileservice.resolver.ProfileResolutionFilter;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.profileservice.spi.managed.ManagedProfile;
import org.jboss.profileservice.spi.managed.ManagedProfileConfiguration;
import org.jboss.profileservice.spi.managed.ManagedProfileDeployer;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

public class ProfileControllerContext
extends AbstractKernelControllerContext
implements ManagedProfile {
    private ProfileActivationService activationService;
    private ProfileMetaDataContext metaDataContext;

    protected ProfileControllerContext(BeanMetaData metaData, ProfileActivationService activationService, Object target) {
        super(null, metaData, (KernelControllerContextActions)(target != null ? ProfileControllerContextActions.getNoInstantiate() : ProfileControllerContextActions.getInstance()), target);
        this.activationService = activationService;
    }

    public Profile getProfile() {
        return (Profile)Profile.class.cast(super.getTarget());
    }

    public ProfileKey getProfileKey() {
        return this.getDependencyContext().getKey();
    }

    public ProfileMetaData getProfileMetaData() {
        return this.getDependencyContext().getProfileMetaData();
    }

    public ManagedProfileDeployer getManagedDeployer() {
        return new DelegateDeployer(this);
    }

    public ManagedProfileConfiguration getConfiguration() {
        if (this.getProfileMetaData() instanceof ManagedProfileConfiguration) {
            return (ManagedProfileConfiguration)ManagedProfileConfiguration.class.cast(this.getProfileMetaData());
        }
        return null;
    }

    public ManagedDeployment getManagedDeployment(ProfileDeployment deployment) throws Exception {
        return this.getDeployerPlugin().getManagedDeployment(deployment);
    }

    public ProfileMetaDataContext getDependencyContext() {
        return this.metaDataContext;
    }

    ProfileDeployerPlugin getDeployerPlugin() {
        return this.getActivationService().getConfiguration().getDeployerRegistry().getDeployer(this.getProfileMetaData());
    }

    void setDependencyContext(ProfileMetaDataContext ctx) {
        this.metaDataContext = ctx;
    }

    ProfileKey resolve(ProfileRequirement requirement) {
        ProfileRequirementResolutionContext context = new ProfileRequirementResolutionContext(this.getDependencyContext(), requirement);
        return this.getActivationService().getProfileServiceRepository().resolve(context, ProfileResolutionFilter.NOOP_FILTER);
    }

    ProfileActivationService getActivationService() {
        return this.activationService;
    }

    static class DelegateDeployer
    implements ManagedProfileDeployer {
        private final ProfileControllerContext delegate;

        public DelegateDeployer(ProfileControllerContext context) {
            this.delegate = context;
        }

        public void addDeployment(ProfileDeployment deployment) throws Exception {
            this.delegate.getDeployerPlugin().addDeployment(this.delegate.getProfileKey(), deployment);
        }

        public void checkComplete(String ... names) throws Exception {
            this.delegate.getDeployerPlugin().checkComplete(names);
        }

        public void process() {
            this.delegate.getDeployerPlugin().process();
        }

        public void removeDeployment(ProfileDeployment deployment) throws Exception {
            this.delegate.getDeployerPlugin().removeDeployment(this.delegate.getProfileKey(), deployment);
        }
    }
}

