/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.bootstrap;

import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.registry.BeanKernelRegistryEntry;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.profileservice.AbstractProfileService;
import org.jboss.profileservice.config.ManagementDomain;
import org.jboss.profileservice.config.ProfileServiceConfig;
import org.jboss.profileservice.config.ServerConfiguration;
import org.jboss.profileservice.dependency.ProfileActivationService;
import org.jboss.profileservice.domain.AbstractDomainMetaData;
import org.jboss.profileservice.domain.ManagementDomainMetaData;
import org.jboss.profileservice.domain.ServerMetaData;
import org.jboss.profileservice.repository.ProfileMetaDataRepository;
import org.jboss.profileservice.repository.ProfileRepositories;
import org.jboss.profileservice.spi.ProfileService;

abstract class AbstractProfileServiceInitializer {
    private final ProfileServiceConfig config;
    protected ProfileRepositories profileRepository;
    private ProfileActivationService activationService;
    private ProfileService profileService;

    public AbstractProfileServiceInitializer(ProfileServiceConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("null profile service config.");
        }
        this.config = config;
    }

    protected ProfileServiceConfig getConfig() {
        return this.config;
    }

    public ProfileMetaDataRepository getProfileRepository() {
        return this.profileRepository;
    }

    protected ProfileService getProfileService() {
        if (this.profileService == null) {
            throw new IllegalStateException("ProfileService not initialized");
        }
        return this.profileService;
    }

    protected ProfileActivationService getActivationService() {
        return this.activationService;
    }

    protected abstract Kernel getKernel();

    public void initialize(AbstractDomainMetaData domainMetaData) throws Throwable {
        this.config.setManagementDomain(this.createManagementDomain(domainMetaData));
        this.config.setServerConfiguration(this.createServerConfiguration(domainMetaData));
        this.initializeProfileService();
    }

    public ProfileService initializeProfileService() throws Throwable {
        this.profileRepository = this.createProfileMetaDataRepository();
        this.activationService = new ProfileActivationService(this.getKernel(), this.profileRepository);
        this.profileService = new AbstractProfileService(this.activationService);
        this.register("jboss.profileservice:service=ProfileService", this.profileService);
        return this.profileService;
    }

    protected ProfileRepositories createProfileMetaDataRepository() throws Throwable {
        ProfileRepositories profileRepository = new ProfileRepositories(this.config);
        this.register("jboss.profileservice:service=ProfileRepository", profileRepository);
        return profileRepository;
    }

    protected ManagementDomain createManagementDomain(AbstractDomainMetaData domainMetaData) {
        ManagementDomainMetaData domain = domainMetaData.getDomain();
        if (domain == null) {
            throw new IllegalArgumentException("null domain meta data");
        }
        String domainName = domain.getDomainName();
        if (domainName == null) {
            throw new IllegalArgumentException("null domain name");
        }
        if ((domainName = domainName.trim()).length() == 0) {
            throw new IllegalArgumentException("empty domain name");
        }
        return new ManagementDomain(domainName);
    }

    protected ServerConfiguration createServerConfiguration(AbstractDomainMetaData domainMetaData) {
        ServerMetaData serverMetaData = domainMetaData.getServer();
        if (serverMetaData == null) {
            throw new IllegalArgumentException("null server meta data");
        }
        String serverName = serverMetaData.getName();
        if (serverName == null) {
            throw new IllegalArgumentException("null server name");
        }
        if ((serverName = serverName.trim()).length() == 0) {
            throw new IllegalArgumentException("empty server name");
        }
        return new ServerConfiguration(serverName);
    }

    protected void register(Object name, Object object) throws Throwable {
        this.register(this.getKernel(), name, object);
    }

    protected void register(Kernel kernel, Object name, Object object) throws Throwable {
        KernelRegistryEntry entry = this.createKernelRegistryEntry(kernel, object);
        KernelRegistry registry = kernel.getRegistry();
        registry.registerEntry(name, entry);
    }

    protected KernelRegistryEntry createKernelRegistryEntry(Kernel kernel, Object object) throws Throwable {
        KernelConfig config = kernel.getConfig();
        BeanInfo info = config.getBeanInfo(object.getClass());
        return new BeanKernelRegistryEntry(object, info);
    }
}

