/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.transporter.custom.server;

import java.net.InetAddress;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.remoting.detection.jndi.JNDIDetector;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.samples.transporter.basic.CustomerProcessor;
import org.jboss.remoting.samples.transporter.basic.CustomerProcessorImpl;
import org.jboss.remoting.transporter.InternalTransporterServices;
import org.jboss.remoting.transporter.TransporterServer;

public class RMIServer {
    private String localLocatorURI = "rmi://localhost:5500";
    private TransporterServer server = null;

    public void start() throws Exception {
        this.initTransporterServices();
        this.server = TransporterServer.createTransporterServer(this.localLocatorURI, (Object)new CustomerProcessorImpl(), CustomerProcessor.class.getName(), true);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private void initTransporterServices() throws Exception {
        MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();
        NetworkRegistry registry = NetworkRegistry.getInstance();
        String host = InetAddress.getLocalHost().getHostAddress();
        JNDIDetector jndiDetector = new JNDIDetector();
        jndiDetector.setPort(2410);
        jndiDetector.setHost(host);
        jndiDetector.setContextFactory("org.jnp.interfaces.NamingContextFactory");
        jndiDetector.setURLPackage("org.jboss.naming:org.jnp.interfaces");
        InternalTransporterServices transporterService = InternalTransporterServices.getInstance();
        transporterService.setup(mbeanServer, jndiDetector, new ObjectName("remoting:type=Detector,transport=jndi"), registry, new ObjectName("remoting:type=NetworkRegistry"), true, true);
        jndiDetector.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RMIServer server = new RMIServer();
        try {
            server.start();
            Thread.currentThread();
            Thread.sleep(60000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
        }
    }
}

