/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.util;

import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.OpenStegoPlugin;
import com.openstego.desktop.util.CommonUtil;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.UserPreferences;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;

public class ImageUtil {
    public static String DEFAULT_IMAGE_TYPE = "png";

    private ImageUtil() {
    }

    public static ImageHolder generateRandomImage(int numOfPixels) throws OpenStegoException {
        double ASPECT_RATIO = 1.3333333333333333;
        int width = 0;
        int height = 0;
        byte[] rgbValue = new byte[3];
        BufferedImage image = null;
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
            width = (int)Math.ceil(Math.sqrt((double)numOfPixels * 1.3333333333333333));
            height = (int)Math.ceil((double)numOfPixels / (double)width);
            image = new BufferedImage(width, height, 1);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    random.nextBytes(rgbValue);
                    image.setRGB(x, y, CommonUtil.byteToInt(rgbValue[0]) + (CommonUtil.byteToInt(rgbValue[1]) << 8) + (CommonUtil.byteToInt(rgbValue[2]) << 16));
                }
            }
            return new ImageHolder(image, null);
        }
        catch (NoSuchAlgorithmException nsaEx) {
            throw new OpenStegoException(nsaEx);
        }
    }

    public static byte[] imageToByteArray(ImageHolder image, String imageFileName, OpenStegoPlugin plugin) throws OpenStegoException {
        ByteArrayOutputStream barrOS = new ByteArrayOutputStream();
        String imageType = null;
        if (imageFileName != null) {
            imageType = imageFileName.substring(imageFileName.lastIndexOf(46) + 1).toLowerCase();
            if (!plugin.getWritableFileExtensions().contains(imageType)) {
                throw new OpenStegoException(null, "OpenStego", 7, imageType);
            }
            if (imageType.equals("jp2")) {
                imageType = "jpeg 2000";
            }
            ImageUtil.writeImage(image, imageType, barrOS);
        } else {
            ImageUtil.writeImage(image, DEFAULT_IMAGE_TYPE, barrOS);
        }
        return barrOS.toByteArray();
    }

    public static ImageHolder byteArrayToImage(byte[] imageData, String imgFileName) throws OpenStegoException {
        if (imageData == null) {
            return null;
        }
        ImageHolder image = ImageUtil.readImage(new ByteArrayInputStream(imageData));
        if (image == null) {
            throw new OpenStegoException(null, "OpenStego", 8, imgFileName);
        }
        return image;
    }

    public static List<int[][]> getRgbFromImage(BufferedImage image) {
        ArrayList<int[][]> rgb = new ArrayList<int[][]>();
        int[][] r = null;
        int[][] g = null;
        int[][] b = null;
        int width = 0;
        int height = 0;
        width = image.getWidth();
        height = image.getHeight();
        r = new int[height][width];
        g = new int[height][width];
        b = new int[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                r[i][j] = image.getRGB(j, i) >> 16 & 0xFF;
                g[i][j] = image.getRGB(j, i) >> 8 & 0xFF;
                b[i][j] = image.getRGB(j, i) >> 0 & 0xFF;
            }
        }
        rgb.add(r);
        rgb.add(g);
        rgb.add(b);
        return rgb;
    }

    public static List<int[][]> getYuvFromImage(BufferedImage image) {
        ArrayList<int[][]> yuv = new ArrayList<int[][]>();
        int[][] y = null;
        int[][] u = null;
        int[][] v = null;
        int[][] aa = null;
        int a = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int width = 0;
        int height = 0;
        width = image.getWidth();
        height = image.getHeight();
        y = new int[height][width];
        u = new int[height][width];
        v = new int[height][width];
        aa = new int[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                a = image.getRGB(j, i) >> 24 & 0xFF;
                r = image.getRGB(j, i) >> 16 & 0xFF;
                g = image.getRGB(j, i) >> 8 & 0xFF;
                b = image.getRGB(j, i) >> 0 & 0xFF;
                y[i][j] = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                u[i][j] = (int)(-0.147 * (double)r - 0.289 * (double)g + 0.436 * (double)b);
                v[i][j] = (int)(0.615 * (double)r - 0.515 * (double)g - 0.1 * (double)b);
                aa[i][j] = a;
            }
        }
        yuv.add(y);
        yuv.add(u);
        yuv.add(v);
        yuv.add(aa);
        return yuv;
    }

    public static BufferedImage getImageFromRgb(List<int[][]> rgb) {
        BufferedImage image = null;
        int width = 0;
        int height = 0;
        int[][] r = null;
        int[][] g = null;
        int[][] b = null;
        r = rgb.get(0);
        g = rgb.get(1);
        b = rgb.get(2);
        height = r.length;
        width = r[0].length;
        image = new BufferedImage(width, height, 1);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                image.setRGB(j, i, (r[i][j] << 16) + (g[i][j] << 8) + b[i][j]);
            }
        }
        return image;
    }

    public static BufferedImage getImageFromYuv(List<int[][]> yuv, int imgType) {
        BufferedImage image = null;
        int width = 0;
        int height = 0;
        int a = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int[][] y = null;
        int[][] u = null;
        int[][] v = null;
        int[][] aa = null;
        y = yuv.get(0);
        u = yuv.get(1);
        v = yuv.get(2);
        aa = yuv.get(3);
        height = y.length;
        width = y[0].length;
        image = new BufferedImage(width, height, imgType == 0 ? 1 : imgType);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                r = ImageUtil.pixelRange((double)y[i][j] + 1.14 * (double)v[i][j]);
                g = ImageUtil.pixelRange((double)y[i][j] - 0.395 * (double)u[i][j] - 0.581 * (double)v[i][j]);
                b = ImageUtil.pixelRange((double)y[i][j] + 2.032 * (double)u[i][j]);
                a = aa[i][j];
                image.setRGB(j, i, (a << 24) + (r << 16) + (g << 8) + b);
            }
        }
        return image;
    }

    public static int pixelRange(int p) {
        return p > 255 ? 255 : (p < 0 ? 0 : p);
    }

    public static int pixelRange(double p) {
        return p > 255.0 ? 255 : (p < 0.0 ? 0 : (int)p);
    }

    public static void makeImageSquare(ImageHolder image) {
        int max = 0;
        max = Math.max(image.getImage().getWidth(), image.getImage().getHeight());
        ImageUtil.cropImage(image, max, max);
    }

    public static void cropImage(ImageHolder image, int cropWidth, int cropHeight) {
        BufferedImage retImg = null;
        int width = 0;
        int height = 0;
        width = image.getImage().getWidth();
        height = image.getImage().getHeight();
        retImg = new BufferedImage(cropWidth, cropHeight, 1);
        for (int i = 0; i < cropWidth; ++i) {
            for (int j = 0; j < cropHeight; ++j) {
                if (i < width && j < height) {
                    retImg.setRGB(i, j, image.getImage().getRGB(i, j));
                    continue;
                }
                retImg.setRGB(i, j, 0);
            }
        }
        image.setImage(retImg);
    }

    public static ImageHolder getDiffImage(ImageHolder leftImage, ImageHolder rightImage) throws OpenStegoException {
        int j;
        int i;
        int leftW = 0;
        int leftH = 0;
        int rightW = 0;
        int rightH = 0;
        int min = 0;
        int max = 0;
        int diff = 0;
        BufferedImage diffImage = null;
        leftW = leftImage.getImage().getWidth();
        leftH = leftImage.getImage().getHeight();
        rightW = rightImage.getImage().getWidth();
        rightH = rightImage.getImage().getHeight();
        if (leftW != rightW || leftH != rightH) {
            throw new OpenStegoException(null, "OpenStego", 8);
        }
        diffImage = new BufferedImage(leftW, leftH, 1);
        max = min = Math.abs(leftImage.getImage().getRGB(0, 0) - rightImage.getImage().getRGB(0, 0));
        for (i = 0; i < leftW; ++i) {
            for (j = 0; j < leftH; ++j) {
                diff = Math.abs(leftImage.getImage().getRGB(i, j) - rightImage.getImage().getRGB(i, j));
                if (diff < min) {
                    min = diff;
                }
                if (diff <= max) continue;
                max = diff;
            }
        }
        for (i = 0; i < leftW; ++i) {
            for (j = 0; j < leftH; ++j) {
                diff = Math.abs(leftImage.getImage().getRGB(i, j) - rightImage.getImage().getRGB(i, j));
                diffImage.setRGB(i, j, ImageUtil.pixelRange((double)(diff - min) / (double)(max - min) * Math.pow(2.0, 32.0)));
            }
        }
        return new ImageHolder(diffImage, null);
    }

    private static void writeImage(ImageHolder image, String imageType, OutputStream os) throws OpenStegoException {
        if ("jpeg".equals(imageType) || "jpg".equals(imageType)) {
            ImageUtil.writeJpegImage(image, os);
        } else {
            try {
                ImageWriter writer = ImageIO.getImageWritersByFormatName(imageType).next();
                writer.setOutput(ImageIO.createImageOutputStream(os));
                writer.write(null, new IIOImage(image.getImage(), null, image.getMetadata()), null);
            }
            catch (IOException e) {
                throw new OpenStegoException(e);
            }
        }
    }

    private static void writeJpegImage(ImageHolder image, OutputStream os) throws OpenStegoException {
        try {
            JPEGImageWriteParam jpegParams = new JPEGImageWriteParam(null);
            jpegParams.setCompressionMode(2);
            jpegParams.setOptimizeHuffmanTables(true);
            Float qual = UserPreferences.getFloat("image.writer.jpeg.quality");
            if (qual == null) {
                qual = Float.valueOf(0.75f);
            }
            jpegParams.setCompressionQuality(qual.floatValue());
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
            writer.setOutput(ImageIO.createImageOutputStream(os));
            writer.write(null, new IIOImage(image.getImage(), null, image.getMetadata()), jpegParams);
        }
        catch (IOException e) {
            throw new OpenStegoException(e);
        }
    }

    private static ImageHolder readImage(InputStream is) throws OpenStegoException {
        try {
            ImageInputStream imageIS = ImageIO.createImageInputStream(is);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(imageIS);
            if (!readers.hasNext()) {
                return null;
            }
            ImageReader reader = readers.next();
            reader.setInput(imageIS);
            BufferedImage image = reader.read(0);
            IIOMetadata metadata = reader.getImageMetadata(0);
            return new ImageHolder(image, metadata);
        }
        catch (IOException e) {
            throw new OpenStegoException(e);
        }
    }
}

