/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class AcrylBorders
extends BaseBorders {
    private static Border textFieldBorder = null;
    private static Border spinnerBorder = null;
    private static Border comboBoxBorder = null;
    private static Border scrollPaneBorder = null;
    private static Border tableScrollPaneBorder = null;
    private static Border buttonBorder = null;
    private static Border rolloverToolButtonBorder = null;
    private static Border internalFrameBorder = null;

    public static Border getTextBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new TextFieldBorder();
        }
        return textFieldBorder;
    }

    public static Border getSpinnerBorder() {
        if (spinnerBorder == null) {
            spinnerBorder = new SpinnerBorder();
        }
        return spinnerBorder;
    }

    public static Border getTextFieldBorder() {
        return AcrylBorders.getTextBorder();
    }

    public static Border getComboBoxBorder() {
        if (comboBoxBorder == null) {
            comboBoxBorder = new ComboBoxBorder();
        }
        return comboBoxBorder;
    }

    public static Border getScrollPaneBorder() {
        if (scrollPaneBorder == null) {
            scrollPaneBorder = new ScrollPaneBorder(false);
        }
        return scrollPaneBorder;
    }

    public static Border getTableScrollPaneBorder() {
        if (tableScrollPaneBorder == null) {
            tableScrollPaneBorder = new ScrollPaneBorder(true);
        }
        return tableScrollPaneBorder;
    }

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return AcrylBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public InternalFrameBorder() {
            this.insets.top = 3;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = this.isActive(component);
            int n5 = this.getTitleHeight(component);
            Color color = ColorHelper.brighter(AcrylLookAndFeel.getWindowInactiveTitleColorLight(), 10.0);
            ColorUIResource colorUIResource = AcrylLookAndFeel.getWindowInactiveTitleColorLight();
            Color color2 = ColorHelper.darker(AcrylLookAndFeel.getWindowInactiveBorderColor(), 10.0);
            if (bl) {
                color = AcrylLookAndFeel.getWindowTitleColorLight();
                colorUIResource = AcrylLookAndFeel.getWindowTitleColorLight();
                color2 = ColorHelper.darker(AcrylLookAndFeel.getWindowBorderColor(), 10.0);
            }
            graphics.setColor(color);
            graphics.fillRect(n, n2 + 1, n3, this.insets.top - 1);
            graphics.setColor(colorUIResource);
            graphics.fillRect(n + 1, n2 + n4 - 5, n3 - 2, 4);
            if (bl) {
                JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getWindowTitleColors(), 1, this.insets.top, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getWindowTitleColors(), n3 - 5, this.insets.top, 5, n5 + 1);
            } else {
                JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, this.insets.top, 4, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, AcrylLookAndFeel.getTheme().getWindowInactiveTitleColors(), n3 - 5, this.insets.top, 4, n5 + 1);
            }
            graphics.setColor(colorUIResource);
            graphics.fillRect(1, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            graphics.fillRect(n3 - 5, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            graphics.setColor(color2);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.drawLine(n + 5 - 1, n2 + this.insets.top + n5, n + 5 - 1, n2 + n4 - 5);
            graphics.drawLine(n + n3 - 5, n2 + this.insets.top + n5, n + n3 - 5, n2 + n4 - 5);
            graphics.drawLine(n + 5 - 1, n2 + n4 - 5, n + n3 - 5, n2 + n4 - 5);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    Color color = ColorHelper.darker(AbstractLookAndFeel.getToolbarBackgroundColor(), 30.0);
                    graphics.setColor(color);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.1f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.black);
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                } else if (buttonModel.isRollover()) {
                    ColorUIResource colorUIResource = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color color = ColorHelper.darker(colorUIResource, 5.0);
                    Color color2 = ColorHelper.darker(colorUIResource, 30.0);
                    JTattooUtilities.draw3DBorder(graphics, color, color2, n, n2, n3, n4);
                    color = Color.white;
                    color2 = ColorHelper.brighter(color2, 60.0);
                    JTattooUtilities.draw3DBorder(graphics, color, color2, n + 1, n2 + 1, n3 - 2, n4 - 2);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.white);
                    graphics.fillRect(n + 2, n2 + 2, n3 - 4, n4 - 4);
                    graphics2D.setComposite(composite);
                } else if (buttonModel.isSelected()) {
                    ColorUIResource colorUIResource = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color color = Color.white;
                    Color color3 = ColorHelper.darker(colorUIResource, 30.0);
                    JTattooUtilities.draw3DBorder(graphics, color3, color, n, n2, n3, n4);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = RolloverToolButtonBorder.insets.left;
            insets.top = RolloverToolButtonBorder.insets.top;
            insets.right = RolloverToolButtonBorder.insets.right;
            insets.bottom = RolloverToolButtonBorder.insets.bottom;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(3, 6, 3, 6);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 50.0);
            if (!JTattooUtilities.isFrameActive(abstractButton)) {
                color = ColorHelper.brighter(color, 30.0);
            }
            if (buttonModel.isRollover() && !buttonModel.isPressed() && !buttonModel.isArmed()) {
                color = AbstractLookAndFeel.getTheme().getRolloverColorDark();
            }
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.white);
            graphics2D.drawRoundRect(n, n2, n3 - 1, n4 - 1, 6, 6);
            graphics2D.setColor(color);
            graphics2D.drawRoundRect(n, n2, n3 - 2, n4 - 2, 6, 6);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(ButtonBorder.insets.top, ButtonBorder.insets.left, ButtonBorder.insets.bottom, ButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = ButtonBorder.insets.left;
            insets.top = ButtonBorder.insets.top;
            insets.right = ButtonBorder.insets.right;
            insets.bottom = ButtonBorder.insets.bottom;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);
        private static final Insets tableInsets = new Insets(1, 1, 1, 1);
        private boolean tableBorder = false;

        public ScrollPaneBorder(boolean bl) {
            this.tableBorder = bl;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 50.0));
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getBackgroundColor(), 50.0));
            graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
        }

        public Insets getBorderInsets(Component component) {
            if (this.tableBorder) {
                return new Insets(ScrollPaneBorder.tableInsets.top, ScrollPaneBorder.tableInsets.left, ScrollPaneBorder.tableInsets.bottom, ScrollPaneBorder.tableInsets.right);
            }
            return new Insets(ScrollPaneBorder.insets.top, ScrollPaneBorder.insets.left, ScrollPaneBorder.insets.bottom, ScrollPaneBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = this.getBorderInsets(component);
            insets.left = insets2.left;
            insets.top = insets2.top;
            insets.right = insets2.right;
            insets.bottom = insets2.bottom;
            return insets;
        }
    }

    public static class ComboBoxBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 50.0);
            graphics.setColor(color);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(ComboBoxBorder.insets.top, ComboBoxBorder.insets.left, ComboBoxBorder.insets.bottom, ComboBoxBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = ComboBoxBorder.insets.left;
            insets.top = ComboBoxBorder.insets.top;
            insets.right = ComboBoxBorder.insets.right;
            insets.bottom = ComboBoxBorder.insets.bottom;
            return insets;
        }
    }

    public static class SpinnerBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 50.0);
            graphics.setColor(color);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(SpinnerBorder.insets.top, SpinnerBorder.insets.left, SpinnerBorder.insets.bottom, SpinnerBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = SpinnerBorder.insets.left;
            insets.top = SpinnerBorder.insets.top;
            insets.right = SpinnerBorder.insets.right;
            insets.bottom = SpinnerBorder.insets.bottom;
            return insets;
        }
    }

    public static class TextFieldBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 50.0);
            graphics.setColor(color);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(TextFieldBorder.insets.top, TextFieldBorder.insets.left, TextFieldBorder.insets.bottom, TextFieldBorder.insets.right);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.left = TextFieldBorder.insets.left;
            insets.top = TextFieldBorder.insets.top;
            insets.right = TextFieldBorder.insets.right;
            insets.bottom = TextFieldBorder.insets.bottom;
            return insets;
        }
    }
}

