/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.commandline;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.resource.ResourceHelper;

public abstract class CommandLineImpl
implements CommandLine {
    @Override
    public final boolean hasOption(String trigger) {
        return this.hasOption(this.getOption(trigger));
    }

    @Override
    public final List getValues(String trigger) {
        return this.getValues(this.getOption(trigger), Collections.EMPTY_LIST);
    }

    @Override
    public final List getValues(String trigger, List defaultValues) {
        return this.getValues(this.getOption(trigger), defaultValues);
    }

    @Override
    public final List getValues(Option option) {
        return this.getValues(option, Collections.EMPTY_LIST);
    }

    @Override
    public final Object getValue(String trigger) {
        return this.getValue(this.getOption(trigger), null);
    }

    @Override
    public final Object getValue(String trigger, Object defaultValue) {
        return this.getValue(this.getOption(trigger), defaultValue);
    }

    @Override
    public final Object getValue(Option option) {
        return this.getValue(option, null);
    }

    @Override
    public final Object getValue(Option option, Object defaultValue) {
        List values = defaultValue == null ? this.getValues(option) : this.getValues(option, Collections.singletonList(defaultValue));
        if (values.size() > 1) {
            throw new IllegalStateException(ResourceHelper.getResourceHelper().getMessage("Argument.too.many.values"));
        }
        if (values.isEmpty()) {
            return defaultValue;
        }
        return values.get(0);
    }

    @Override
    public final Boolean getSwitch(String trigger) {
        return this.getSwitch(this.getOption(trigger), null);
    }

    @Override
    public final Boolean getSwitch(String trigger, Boolean defaultValue) {
        return this.getSwitch(this.getOption(trigger), defaultValue);
    }

    @Override
    public final Boolean getSwitch(Option option) {
        return this.getSwitch(option, null);
    }

    @Override
    public final String getProperty(Option option, String property) {
        return this.getProperty(option, property, null);
    }

    @Override
    public final int getOptionCount(String trigger) {
        return this.getOptionCount(this.getOption(trigger));
    }

    @Override
    public final int getOptionCount(Option option) {
        if (option == null) {
            return 0;
        }
        int count = 0;
        Iterator i = this.getOptions().iterator();
        while (i.hasNext()) {
            if (!option.equals(i.next())) continue;
            ++count;
        }
        return count;
    }
}

