/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.exceptions.FileTransferFailedException;
import cz.vity.freerapid.utilities.FileEncWriter;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Logger;
import org.jdesktop.application.Application;

public class MoveFileTask
extends CoreTask<Void, Void> {
    private static final Logger logger = Logger.getLogger(MoveFileTask.class.getName());
    private final File from;
    private File to;
    private final boolean deleteSource;
    private final boolean overWriteExisting;
    private final DownloadFile downloadFile;
    private static final int BSIZE = 4096;

    public MoveFileTask(Application application, File from, File to, boolean deleteSource, boolean overWriteExisting, DownloadFile downloadFile) {
        super(application);
        this.from = from;
        this.to = to;
        this.deleteSource = deleteSource;
        this.overWriteExisting = overWriteExisting;
        this.downloadFile = downloadFile;
        this.setTaskToForeground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        if (this.from.equals(this.to) && this.from.exists()) {
            this.saveToHistoryList();
            this.saveDescriptionFiles();
            return null;
        }
        if (!this.from.exists()) {
            return null;
        }
        if (this.to.exists()) {
            if (!this.overWriteExisting) {
                this.to = this.getNewUniqueFileName(this.to);
            } else {
                this.to.delete();
            }
        }
        this.message("Moving_file", new Object[0]);
        File parentToDir = this.to.getParentFile();
        if (!parentToDir.exists() && !parentToDir.mkdirs()) {
            throw new FileTransferFailedException(this.getResourceMap().getString("creatingOutputFilePathFailed", new Object[0]));
        }
        if (this.from.renameTo(this.to)) {
            this.saveToHistoryList();
            this.saveDescriptionFiles();
            return null;
        }
        this.saveDescriptionFiles();
        FileChannel ic = null;
        AbstractInterruptibleChannel oc = null;
        try {
            try {
                int read;
                ic = new FileInputStream(this.from).getChannel();
                oc = new FileOutputStream(this.to).getChannel();
                long size = this.from.length();
                ByteBuffer buffer = ByteBuffer.allocate(4096);
                int counter = 0;
                int i = 0;
                while ((read = ic.read(buffer)) != -1) {
                    buffer.flip();
                    ((FileChannel)oc).write(buffer);
                    buffer.clear();
                    counter += read;
                    if (i++ % 32 != 0) continue;
                    this.setProgress((float)counter, 0.0f, size);
                }
            }
            finally {
                try {
                    if (ic != null) {
                        ic.close();
                    }
                }
                catch (IOException e) {
                    LogUtils.processException(logger, e);
                }
                try {
                    if (oc != null) {
                        oc.close();
                    }
                }
                catch (IOException e) {
                    LogUtils.processException(logger, e);
                }
            }
            this.saveToHistoryList();
        }
        catch (Exception e) {
            if (this.to.exists()) {
                this.to.delete();
            }
            this.deleteDescriptionFileOnError();
        }
        finally {
            if (this.deleteSource && this.from.exists()) {
                this.from.delete();
            }
        }
        return null;
    }

    private void deleteDescriptionFileOnError() {
        File descTxtFile;
        String desc = this.downloadFile.getDescription();
        if (desc == null || desc.isEmpty()) {
            return;
        }
        boolean descriptionFile = AppPrefs.getProperty("generateDescriptionByFileName", false);
        if (descriptionFile && (descTxtFile = new File(this.to.getParentFile(), this.getNameForFile(Utils.getPureFilenameWithDots(this.to) + ".txt"))).exists()) {
            descTxtFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDescriptionFiles() {
        boolean descriptionFile;
        String desc = this.downloadFile.getDescription();
        if (desc == null || desc.isEmpty()) {
            return;
        }
        boolean descIon = AppPrefs.getProperty("generateDescript-ionFile", false);
        boolean trim = AppPrefs.getProperty("trimDescription", true);
        if (trim) {
            desc = desc.trim();
        }
        if (descIon) {
            File descriptIonFile = new File(this.to.getParentFile(), this.getNameForFile("descript.ion"));
            FileEncWriter writer = null;
            try {
                writer = new FileEncWriter(descriptIonFile, true, this.getCharsetForPropertiesFile());
                if (descriptIonFile.length() > 0L) {
                    writer.write(Utils.getSystemLineSeparator());
                }
                writer.write(this.to.getName() + " " + desc.trim());
            }
            catch (IOException e) {
                LogUtils.processException(logger, e);
            }
            finally {
                if (writer != null) {
                    if (this.generateFileAsHidden() && Utils.isWindows()) {
                        Utils.setFileAsHidden(descriptIonFile);
                    }
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        LogUtils.processException(logger, e);
                    }
                }
            }
        }
        if (descriptionFile = AppPrefs.getProperty("generateDescriptionByFileName", false)) {
            File descTxtFile = new File(this.to.getParentFile(), this.getNameForFile(Utils.getPureFilenameWithDots(this.to) + ".txt"));
            if (descTxtFile.exists() && descTxtFile.isHidden() && !descTxtFile.delete()) {
                logger.warning("Deletion of file " + descTxtFile.getAbsolutePath() + " failed");
            }
            if (descTxtFile.exists()) {
                descTxtFile = new File(this.to.getParentFile(), this.getNameForFile(Utils.getPureFilenameWithDots(this.to) + "-description.txt"));
            }
            if (descTxtFile.exists()) {
                descTxtFile = this.getNewUniqueFileName(descTxtFile);
            }
            FileEncWriter writer = null;
            try {
                writer = new FileEncWriter(descTxtFile, false, this.getCharsetForPropertiesFile());
                writer.write(desc);
            }
            catch (IOException e) {
                LogUtils.processException(logger, e);
            }
            finally {
                if (writer != null) {
                    if (this.generateFileAsHidden() && Utils.isWindows()) {
                        Utils.setFileAsHidden(descTxtFile);
                    }
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        LogUtils.processException(logger, e);
                    }
                }
            }
        }
    }

    private String getNameForFile(String st) {
        if (this.generateFileAsHidden() && !Utils.isWindows() && !st.startsWith(".")) {
            return "." + st;
        }
        return st;
    }

    private boolean generateFileAsHidden() {
        return AppPrefs.getProperty("descriptionFilesHidden", false);
    }

    private void saveToHistoryList() {
        this.downloadFile.setFileName(this.to.getName());
        logger.info("Saving to history " + this.downloadFile.getFileName());
        boolean saveHistory = AppPrefs.getProperty("useHistory", true);
        if (saveHistory) {
            ((MainApp)this.getApplication()).getManagerDirector().getFileHistoryManager().addHistoryItem(this.downloadFile, this.to);
        }
    }

    @Override
    protected void failed(Throwable cause) {
        super.failed(cause);
    }

    private File getNewUniqueFileName(File to) {
        File newFile;
        File dir = to.getParentFile();
        String pureFileName = Utils.getPureFilenameWithDots(to);
        String ext = Utils.getExtension(to);
        ext = ext != null ? "." + ext : "";
        int counter = 2;
        while ((newFile = new File(dir, pureFileName + "-" + String.valueOf(counter) + ext)).exists()) {
            ++counter;
        }
        return newFile;
    }

    private Charset getCharsetForPropertiesFile() {
        Charset charset;
        String encoding = AppPrefs.getProperty("charEncodingForPropertiesFiles", Charset.defaultCharset().name());
        try {
            charset = Charset.forName(encoding);
        }
        catch (UnsupportedCharsetException e) {
            logger.severe("Unsupported encoding for properties files:" + encoding);
            LogUtils.processException(logger, e);
            return Charset.defaultCharset();
        }
        return charset;
    }
}

