/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange.ews;

import davmail.exchange.ews.FieldURI;
import davmail.util.StringUtil;

public class ExtendedFieldURI
implements FieldURI {
    protected String propertyTag;
    protected DistinguishedPropertySetType distinguishedPropertySetId;
    protected String propertyName;
    protected int propertyId;
    protected final PropertyType propertyType;

    public ExtendedFieldURI(int intPropertyTag, PropertyType propertyType) {
        this.propertyTag = "0x" + Integer.toHexString(intPropertyTag);
        this.propertyType = propertyType;
    }

    public ExtendedFieldURI(DistinguishedPropertySetType distinguishedPropertySetId, int propertyId, PropertyType propertyType) {
        this.distinguishedPropertySetId = distinguishedPropertySetId;
        this.propertyId = propertyId;
        this.propertyType = propertyType;
    }

    public ExtendedFieldURI(DistinguishedPropertySetType distinguishedPropertySetId, String propertyName) {
        this.distinguishedPropertySetId = distinguishedPropertySetId;
        this.propertyName = propertyName;
        this.propertyType = PropertyType.String;
    }

    public ExtendedFieldURI(DistinguishedPropertySetType distinguishedPropertySetId, String propertyName, PropertyType propertyType) {
        this.distinguishedPropertySetId = distinguishedPropertySetId;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    @Override
    public void appendTo(StringBuilder buffer) {
        buffer.append("<t:ExtendedFieldURI");
        if (this.propertyTag != null) {
            buffer.append(" PropertyTag=\"").append(this.propertyTag).append('\"');
        }
        if (this.distinguishedPropertySetId != null) {
            buffer.append(" DistinguishedPropertySetId=\"").append((Object)this.distinguishedPropertySetId).append('\"');
        }
        if (this.propertyName != null) {
            buffer.append(" PropertyName=\"").append(this.propertyName).append('\"');
        }
        if (this.propertyId != 0) {
            buffer.append(" PropertyId=\"").append(this.propertyId).append('\"');
        }
        if (this.propertyType != null) {
            buffer.append(" PropertyType=\"").append(this.propertyType.toString()).append('\"');
        }
        buffer.append("/>");
    }

    @Override
    public void appendValue(StringBuilder buffer, String itemType, String value) {
        if (itemType != null) {
            this.appendTo(buffer);
            buffer.append("<t:");
            buffer.append(itemType);
            buffer.append('>');
        }
        buffer.append("<t:ExtendedProperty>");
        this.appendTo(buffer);
        if (this.propertyType == PropertyType.StringArray) {
            String[] values;
            buffer.append("<t:Values>");
            for (String singleValue : values = value.split(",")) {
                buffer.append("<t:Value>");
                buffer.append(StringUtil.xmlEncode(singleValue));
                buffer.append("</t:Value>");
            }
            buffer.append("</t:Values>");
        } else {
            buffer.append("<t:Value>");
            if ("0x10f3".equals(this.propertyTag)) {
                buffer.append(StringUtil.xmlEncode(StringUtil.encodeUrlcompname(value)));
            } else {
                buffer.append(StringUtil.xmlEncode(value));
            }
            buffer.append("</t:Value>");
        }
        buffer.append("</t:ExtendedProperty>");
        if (itemType != null) {
            buffer.append("</t:");
            buffer.append(itemType);
            buffer.append('>');
        }
    }

    @Override
    public String getResponseName() {
        if (this.propertyTag != null) {
            return this.propertyTag;
        }
        if (this.propertyName != null) {
            return this.propertyName;
        }
        return String.valueOf(this.propertyId);
    }

    protected static enum DistinguishedPropertySetType {
        Meeting,
        Appointment,
        Common,
        PublicStrings,
        Address,
        InternetHeaders,
        CalendarAssistant,
        UnifiedMessaging,
        Task;

    }

    protected static enum PropertyType {
        ApplicationTime,
        ApplicationTimeArray,
        Binary,
        BinaryArray,
        Boolean,
        CLSID,
        CLSIDArray,
        Currency,
        CurrencyArray,
        Double,
        DoubleArray,
        Error,
        Float,
        FloatArray,
        Integer,
        IntegerArray,
        Long,
        LongArray,
        Null,
        Object,
        ObjectArray,
        Short,
        ShortArray,
        SystemTime,
        SystemTimeArray,
        String,
        StringArray;

    }
}

