/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import org.htmlcleaner.CData;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.Serializer;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;

public abstract class XmlSerializer
extends Serializer {
    public static final String XMLNS_NAMESPACE = "xmlns";
    private boolean creatingHtmlDom;

    protected XmlSerializer(CleanerProperties props) {
        super(props);
    }

    public void setCreatingHtmlDom(boolean creatingHtmlDom) {
        this.creatingHtmlDom = creatingHtmlDom;
    }

    public boolean isCreatingHtmlDom() {
        return this.creatingHtmlDom;
    }

    @Deprecated
    public void writeXmlToStream(TagNode tagNode, OutputStream out, String charset) throws IOException {
        super.writeToStream(tagNode, out, charset);
    }

    @Deprecated
    public void writeXmlToStream(TagNode tagNode, OutputStream out) throws IOException {
        super.writeToStream(tagNode, out);
    }

    @Deprecated
    public void writeXmlToFile(TagNode tagNode, String fileName, String charset) throws IOException {
        super.writeToFile(tagNode, fileName, charset);
    }

    @Deprecated
    public void writeXmlToFile(TagNode tagNode, String fileName) throws IOException {
        super.writeToFile(tagNode, fileName);
    }

    @Deprecated
    public String getXmlAsString(TagNode tagNode, String charset) {
        return super.getAsString(tagNode, charset);
    }

    @Deprecated
    public String getXmlAsString(TagNode tagNode) {
        return super.getAsString(tagNode);
    }

    @Deprecated
    public void writeXml(TagNode tagNode, Writer writer, String charset) throws IOException {
        super.write(tagNode, writer, charset);
    }

    protected String escapeXml(String xmlContent) {
        return Utils.escapeXml(xmlContent, this.props, this.isCreatingHtmlDom());
    }

    protected boolean dontEscape(TagNode tagNode) {
        return this.props.isUseCdataFor(tagNode.getName());
    }

    protected boolean isMinimizedTagSyntax(TagNode tagNode) {
        TagInfo tagInfo = this.props.getTagInfoProvider().getTagInfo(tagNode.getName());
        return tagNode.isEmpty() && (tagInfo == null || tagInfo.isMinimizedTagPermitted()) && (this.props.isUseEmptyElementTags() || tagInfo != null && tagInfo.isEmptyTag());
    }

    protected void serializeOpenTag(TagNode tagNode, Writer writer) throws IOException {
        this.serializeOpenTag(tagNode, writer, true);
    }

    protected void serializeCData(CData item, TagNode tagNode, Writer writer) throws IOException {
        if (this.dontEscape(tagNode)) {
            writer.write(item.getContentWithoutStartAndEndTokens());
        } else {
            writer.write(this.escapeXml(item.getContentWithStartAndEndTokens()));
        }
    }

    protected void serializeContentToken(ContentNode item, TagNode tagNode, Writer writer) throws IOException {
        if (this.dontEscape(tagNode)) {
            writer.write(item.getContent());
        } else {
            writer.write(this.escapeXml(item.getContent()));
        }
    }

    protected void serializeOpenTag(TagNode tagNode, Writer writer, boolean newLine) throws IOException {
        if (!this.isForbiddenTag(tagNode)) {
            String tagName = tagNode.getName();
            Map<String, String> tagAtttributes = tagNode.getAttributes();
            if (this.props.isAddNewlineToHeadAndBody() && this.isHeadOrBody(tagName)) {
                writer.write("\n");
            }
            writer.write("<" + tagName);
            for (Map.Entry<String, String> entry : tagAtttributes.entrySet()) {
                String attName = entry.getKey();
                String attValue = entry.getValue();
                this.serializeAttribute(tagNode, writer, attName, attValue);
            }
            if (this.isMinimizedTagSyntax(tagNode)) {
                writer.write(" />");
                if (newLine) {
                    writer.write("\n");
                }
            } else if (this.dontEscape(tagNode)) {
                writer.write(">");
                if (!tagNode.getText().toString().startsWith("/*<![CDATA[*/")) {
                    char firstchar;
                    writer.write("/*<![CDATA[*/");
                    if (!tagNode.getText().toString().equals("") && (firstchar = tagNode.getText().toString().charAt(0)) != '\n' && firstchar != '\r') {
                        writer.write("\n");
                    }
                }
            } else {
                writer.write(">");
            }
        }
    }

    protected boolean isForbiddenTag(TagNode tagNode) {
        String tagName = tagNode.getName();
        return tagName == null;
    }

    protected boolean isHeadOrBody(String tagName) {
        return "head".equalsIgnoreCase(tagName) || "body".equalsIgnoreCase(tagName);
    }

    protected void serializeAttribute(TagNode tagNode, Writer writer, String attName, String attValue) throws IOException {
        if (!this.props.isAllowInvalidAttributeNames()) {
            attName = Utils.sanitizeXmlAttributeName(attName, this.props.getInvalidXmlAttributeNamePrefix());
        }
        if (attName != null && (Utils.isValidXmlIdentifier(attName) || this.props.isAllowInvalidAttributeNames()) && !this.isForbiddenAttribute(tagNode, attName, attValue)) {
            writer.write(" " + attName + "=\"" + this.escapeXml(attValue) + "\"");
        }
    }

    protected boolean isForbiddenAttribute(TagNode tagNode, String attName, String value) {
        return !this.props.isNamespacesAware() && (XMLNS_NAMESPACE.equals(attName) || attName.startsWith("xmlns:"));
    }

    protected void serializeEndTag(TagNode tagNode, Writer writer) throws IOException {
        this.serializeEndTag(tagNode, writer, true);
    }

    protected void serializeEndTag(TagNode tagNode, Writer writer, boolean newLine) throws IOException {
        if (!this.isForbiddenTag(tagNode)) {
            String tagName = tagNode.getName();
            if (this.dontEscape(tagNode) && !tagNode.getText().toString().trim().endsWith("/*]]>*/")) {
                char lastchar;
                if (tagNode.getText().toString().length() > 0 && (lastchar = tagNode.getText().toString().charAt(tagNode.getText().toString().length() - 1)) != '\n' && lastchar != '\r') {
                    writer.write("\n");
                }
                writer.write("/*]]>*/");
            }
            writer.write("</" + tagName + ">");
            if (newLine) {
                writer.write("\n");
            }
        }
    }
}

