/*
 * Decompiled with CFR 0.152.
 */
package davmail.http.request;

import davmail.http.HttpClientAdapter;
import davmail.http.request.ResponseWrapper;
import java.io.IOException;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;

public class GetRequest
extends HttpGet
implements ResponseHandler<String>,
ResponseWrapper {
    private HttpResponse response;
    private String responseBodyAsString;

    public GetRequest(URI uri) {
        super(uri);
    }

    public GetRequest(String uri) {
        super(uri);
    }

    public String handleResponse(HttpResponse response) throws IOException {
        this.response = response;
        if (HttpClientAdapter.isRedirect(response)) {
            return null;
        }
        this.responseBodyAsString = new BasicResponseHandler().handleResponse(response);
        return this.responseBodyAsString;
    }

    @Override
    public String getResponseBodyAsString() throws IOException {
        this.checkResponse();
        if (this.responseBodyAsString == null) {
            throw new IOException("No response body available");
        }
        return this.responseBodyAsString;
    }

    public Header getResponseHeader(String name) {
        this.checkResponse();
        return this.response.getFirstHeader(name);
    }

    @Override
    public int getStatusCode() {
        this.checkResponse();
        return this.response.getStatusLine().getStatusCode();
    }

    public String getReasonPhrase() {
        this.checkResponse();
        return this.response.getStatusLine().getReasonPhrase();
    }

    public URI getRedirectLocation() {
        this.checkResponse();
        return HttpClientAdapter.getRedirectLocation(this.response);
    }

    @Override
    public HttpResponse getHttpResponse() {
        return this.response;
    }

    private void checkResponse() {
        if (this.response == null) {
            throw new IllegalStateException("Should execute request first");
        }
    }
}

