/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.datepicker.client;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.aria.client.SelectedValue;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import com.google.gwt.user.datepicker.client.CalendarView;
import com.google.gwt.user.datepicker.client.CellGridImpl;
import java.util.Date;
import java.util.Objects;

public final class DefaultCalendarView
extends CalendarView {
    private CellGrid grid = new CellGrid();
    private Date firstDisplayed;
    private Date lastDisplayed = new Date();
    private CellGrid.DateCell ariaSelectedCell;

    @Override
    public void addStyleToDate(String styleName, Date date) {
        assert (this.getDatePicker().isDateVisible(date)) : "You tried to add style " + styleName + " to " + date + ". The calendar is currently showing " + this.getFirstDate() + " to " + this.getLastDate();
        this.getCell(date).addStyleName(styleName);
    }

    @Override
    public Date getFirstDate() {
        return this.firstDisplayed;
    }

    @Override
    public Date getLastDate() {
        return this.lastDisplayed;
    }

    @Override
    public boolean isDateEnabled(Date d) {
        return this.getCell(d).isEnabled();
    }

    @Override
    public void refresh() {
        this.firstDisplayed = this.getModel().getCurrentFirstDayOfFirstWeek();
        if (this.firstDisplayed.getDate() == 1) {
            DefaultCalendarView.addDays(this.firstDisplayed, -7);
        }
        this.lastDisplayed.setTime(this.firstDisplayed.getTime());
        for (int i = 0; i < this.grid.getNumCells(); ++i) {
            if (i != 0) {
                DefaultCalendarView.addDays(this.lastDisplayed, 1);
            }
            CellGrid.DateCell cell = (CellGrid.DateCell)this.grid.getCell(i);
            cell.update(this.lastDisplayed);
        }
        this.setAriaSelectedCell(null);
    }

    private static void addDays(Date date, int days) {
        CalendarUtil.addDaysToDate(date, days);
        CalendarUtil.resetTime(date);
    }

    @Override
    public void removeStyleFromDate(String styleName, Date date) {
        this.getCell(date).removeStyleName(styleName);
    }

    @Override
    public void setAriaSelectedCell(Date date) {
        CellGrid.DateCell newSelectedCell;
        if (this.ariaSelectedCell != null) {
            this.ariaSelectedCell.setAriaSelected(false);
        }
        CellGrid.DateCell dateCell = newSelectedCell = date != null ? this.getCell(date) : null;
        if (newSelectedCell != null) {
            newSelectedCell.setAriaSelected(true);
        }
        this.ariaSelectedCell = newSelectedCell;
    }

    @Override
    public void setEnabledOnDate(boolean enabled, Date date) {
        this.getCell(date).setEnabled(enabled);
    }

    @Override
    public void setup() {
        HTMLTable.CellFormatter formatter = this.grid.getCellFormatter();
        int weekendStartColumn = -1;
        int weekendEndColumn = -1;
        for (int i = 0; i < 7; ++i) {
            int shift = CalendarUtil.getStartingDayOfWeek();
            int dayIdx = i + shift < 7 ? i + shift : i + shift - 7;
            this.grid.setText(0, i, this.getModel().formatDayOfWeek(dayIdx));
            if (CalendarUtil.isWeekend(dayIdx)) {
                formatter.setStyleName(0, i, this.css().weekendLabel());
                if (weekendStartColumn == -1) {
                    weekendStartColumn = i;
                    continue;
                }
                weekendEndColumn = i;
                continue;
            }
            formatter.setStyleName(0, i, this.css().weekdayLabel());
        }
        for (int row = 1; row <= 6; ++row) {
            for (int column = 0; column < 7; ++column) {
                CellGrid cellGrid = this.grid;
                Objects.requireNonNull(cellGrid);
                CellGrid.DateCell cell = cellGrid.new CellGrid.DateCell(column == weekendStartColumn || column == weekendEndColumn);
                this.grid.setWidget(row, column, cell);
            }
        }
        this.initWidget(this.grid);
        this.grid.setStyleName(this.css().days());
    }

    private CellGrid.DateCell getCell(Date d) {
        int index = CalendarUtil.getDaysBetween(this.firstDisplayed, d);
        if (index < 0 || this.grid.getNumCells() <= index) {
            return null;
        }
        CellGrid.DateCell cell = (CellGrid.DateCell)this.grid.getCell(index);
        if (((Date)cell.getValue()).getDate() != d.getDate()) {
            throw new IllegalStateException(d + " cannot be associated with cell " + cell + " as it has date " + cell.getValue());
        }
        return cell;
    }

    class CellGrid
    extends CellGridImpl<Date> {
        CellGrid() {
            this.resize(7, 7);
        }

        @Override
        protected void onSelected(CellGridImpl.Cell lastSelected, CellGridImpl.Cell cell) {
        }

        class DateCell
        extends CellGridImpl.Cell {
            private String cellStyle;
            private String dateStyle;

            DateCell(boolean isWeekend) {
                super(new Date());
                this.cellStyle = DefaultCalendarView.this.css().day();
                if (isWeekend) {
                    this.cellStyle = this.cellStyle + " " + DefaultCalendarView.this.css().dayIsWeekend();
                }
                this.getElement().setTabIndex(this.isFiller() ? -1 : 0);
                this.setAriaSelected(false);
            }

            @Override
            public void addStyleName(String styleName) {
                if (this.dateStyle.indexOf(" " + styleName + " ") == -1) {
                    this.dateStyle = this.dateStyle + styleName + " ";
                }
                this.updateStyle();
            }

            public boolean isFiller() {
                return !DefaultCalendarView.this.getModel().isInCurrentMonth((Date)this.getValue());
            }

            @Override
            public void onHighlighted(boolean highlighted) {
                DefaultCalendarView.this.setHighlightedDate((Date)this.getValue());
                this.updateStyle();
            }

            @Override
            public void onSelected(boolean selected) {
                if (selected) {
                    DefaultCalendarView.this.getDatePicker().setValue((Date)this.getValue(), true);
                    if (this.isFiller()) {
                        DefaultCalendarView.this.getDatePicker().setCurrentMonth((Date)this.getValue());
                    }
                }
                this.updateStyle();
            }

            @Override
            public void removeStyleName(String styleName) {
                this.dateStyle = this.dateStyle.replace(" " + styleName + " ", " ");
                this.updateStyle();
            }

            public void setAriaSelected(boolean value) {
                Roles.getGridcellRole().setAriaSelectedState(this.getElement(), SelectedValue.of(value));
            }

            @Override
            public void updateStyle() {
                String accum = this.dateStyle;
                if (this.isHighlighted()) {
                    accum = accum + " " + DefaultCalendarView.this.css().dayIsHighlighted();
                    if (this.isHighlighted() && this.isSelected()) {
                        accum = accum + " " + DefaultCalendarView.this.css().dayIsValueAndHighlighted();
                    }
                }
                if (!this.isEnabled()) {
                    accum = accum + " " + DefaultCalendarView.this.css().dayIsDisabled();
                }
                this.setStyleName(accum);
            }

            void update(Date current) {
                this.setEnabled(true);
                ((Date)this.getValue()).setTime(current.getTime());
                String value = DefaultCalendarView.this.getModel().formatDayOfMonth((Date)this.getValue());
                this.setText(value);
                this.dateStyle = this.cellStyle;
                if (this.isFiller()) {
                    this.getElement().setTabIndex(-1);
                    this.dateStyle = this.dateStyle + " " + DefaultCalendarView.this.css().dayIsFiller();
                } else {
                    this.getElement().setTabIndex(0);
                    String extraStyle = DefaultCalendarView.this.getDatePicker().getStyleOfDate(current);
                    if (extraStyle != null) {
                        this.dateStyle = this.dateStyle + " " + extraStyle;
                    }
                }
                this.dateStyle = this.dateStyle + " ";
                this.updateStyle();
            }

            private void setText(String value) {
                this.getElement().setInnerText(value);
            }
        }
    }
}

