/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.crf.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ansj.app.crf.Config;
import org.ansj.app.crf.Model;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.ObjConver;
import org.nlpcn.commons.lang.util.StringUtil;
import org.nlpcn.commons.lang.util.tuples.Pair;

public class WapitiCRFModel
extends Model {
    @Override
    public WapitiCRFModel loadModel(String modelPath) throws Exception {
        InputStream is = IOUtil.getInputStream((String)modelPath);
        Throwable throwable = null;
        try {
            WapitiCRFModel wapitiCRFModel = this.loadModel(is);
            return wapitiCRFModel;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (is != null) {
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    is.close();
                }
            }
        }
    }

    @Override
    public WapitiCRFModel loadModel(InputStream is) throws Exception {
        BufferedReader br = IOUtil.getReader((InputStream)is, (String)"utf-8");
        long start = System.currentTimeMillis();
        logger.info("load wapiti model begin!");
        String temp = br.readLine();
        logger.info(temp);
        Map<String, Integer> featureIndex = this.loadConfig(br);
        StringBuilder sb = new StringBuilder();
        for (int[] t1 : this.config.getTemplate()) {
            sb.append(Arrays.toString(t1) + " ");
        }
        logger.info("featureIndex is " + featureIndex);
        logger.info("load template ok template : " + sb);
        int[] statusCoven = this.loadTagCoven(br);
        List<Pair<String, String>> loadFeatureName = this.loadFeatureName(featureIndex, br);
        logger.info("load feature ok feature size : " + loadFeatureName.size());
        this.featureTree = new SmartForest();
        this.loadFeatureWeight(br, statusCoven, loadFeatureName);
        logger.info("load wapiti model ok ! use time :" + (System.currentTimeMillis() - start));
        return this;
    }

    private void loadFeatureWeight(BufferedReader br, int[] statusCoven, List<Pair<String, String>> featureNames) throws Exception {
        int key = 0;
        int offe = 0;
        int tag = 0;
        int len = 0;
        int max = 0;
        String name = null;
        float[] tempW = null;
        String temp = br.readLine();
        for (Pair<String, String> pair : featureNames) {
            String[] split;
            if (temp == null) {
                logger.warn((String)pair.getValue0() + "\t" + (String)pair.getValue1() + " not have any weight ,so skip it !");
                continue;
            }
            char fc = Character.toUpperCase(((String)pair.getValue0()).charAt(0));
            int n = fc == 'B' ? 16 : (fc == 'U' ? 4 : (len = fc == '*' ? 20 : 0));
            if (len == 0) {
                throw new Exception("unknow feature type " + (String)pair.getValue0());
            }
            int min = max;
            max += len;
            if (fc == 'B') {
                for (int i = 0; i < len; ++i) {
                    String[] split2 = temp.split("=");
                    int from = statusCoven[i / 4];
                    int to = statusCoven[i % 4];
                    this.status[from][to] = ObjConver.getFloatValue((String)split2[1]).floatValue();
                    temp = br.readLine();
                }
                continue;
            }
            name = (String)pair.getValue1();
            tempW = new float[len];
            while ((key = ObjConver.getIntValue((String)(split = temp.split("="))[0])) < max) {
                offe = key - min;
                tag = statusCoven[offe];
                tempW[tag] = ObjConver.getFloatValue((String)split[1]).floatValue();
                temp = br.readLine();
                if (temp != null) continue;
            }
            this.featureTree.add(name, (Object)tempW);
        }
    }

    private List<Pair<String, String>> loadFeatureName(Map<String, Integer> featureIndex, BufferedReader br) throws Exception {
        String temp = br.readLine();
        int featureNum = ObjConver.getIntValue((String)StringUtil.matcherFirst((String)"\\d+", (String)temp));
        ArrayList<Pair<String, String>> featureNames = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < featureNum; ++i) {
            temp = br.readLine();
            String[] split = temp.split(":");
            if (split.length == 2) {
                featureNames.add((Pair<String, String>)Pair.with((Object)split[1], (Object)""));
                continue;
            }
            String name = split[2];
            if (split.length > 3) {
                for (int j = 3; j < split.length; ++j) {
                    name = name + ":" + split[j];
                }
            }
            name = name.substring(0, name.length() - 1);
            int lastFeatureId = featureIndex.get(split[1]);
            if ("/".equals(name)) {
                name = "//";
            }
            if (name.contains("//")) {
                name = name.replaceAll("//", "/XIEGANG/");
            }
            String featureName = this.toFeatureName(name.trim().split("/"), lastFeatureId);
            featureNames.add((Pair<String, String>)Pair.with((Object)split[1], (Object)featureName));
        }
        return featureNames;
    }

    private String toFeatureName(String[] split, int lastFeatureId) throws Exception {
        StringBuilder result = new StringBuilder();
        for (String str : split) {
            if ("".equals(str)) continue;
            if (str.length() == 1) {
                result.append(str.charAt(0));
                continue;
            }
            if (str.equals("XIEGANG")) {
                result.append('/');
                continue;
            }
            if (str.startsWith("num")) {
                result.append((char)(130 + ObjConver.getIntValue((String)str.replace("num", ""))));
                continue;
            }
            if (str.startsWith("en")) {
                result.append((char)(140 + ObjConver.getIntValue((String)str.replace("en", ""))));
                continue;
            }
            if (str.startsWith("_x-")) {
                result.append('\u0080');
                continue;
            }
            if (str.startsWith("_x+")) {
                result.append('\u0081');
                continue;
            }
            throw new Exception("can find feature named " + str + " in " + Arrays.toString(split));
        }
        result.append((char)(lastFeatureId + 150));
        return result.toString();
    }

    private int[] loadTagCoven(BufferedReader br) throws Exception {
        int i;
        int[] conver = new int[20];
        String temp = br.readLine();
        block6: for (i = 0; i < 4; ++i) {
            char c = br.readLine().split(":")[1].charAt(0);
            switch (c) {
                case 'S': {
                    conver[i] = Config.S;
                    continue block6;
                }
                case 'B': {
                    conver[i] = Config.B;
                    continue block6;
                }
                case 'M': {
                    conver[i] = Config.M;
                    continue block6;
                }
                case 'E': {
                    conver[i] = Config.E;
                    continue block6;
                }
                default: {
                    throw new Exception("err tag named " + c + " in model " + temp);
                }
            }
        }
        for (i = 4; i < conver.length; ++i) {
            conver[i] = conver[(i - 4) / 4] * 4 + conver[i % 4] + 4;
        }
        return conver;
    }

    private Map<String, Integer> loadConfig(BufferedReader br) throws IOException {
        HashMap<String, Integer> featureIndex = new HashMap<String, Integer>();
        String temp = br.readLine();
        int featureNum = ObjConver.getIntValue((String)StringUtil.matcherFirst((String)"\\d+", (String)temp));
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int i = 0; i < featureNum; ++i) {
            temp = br.readLine();
            List matcherAll = StringUtil.matcherAll((String)"\\[.*?\\]", (String)temp);
            if (matcherAll.size() == 0) continue;
            int[] is = new int[matcherAll.size()];
            for (int j = 0; j < is.length; ++j) {
                is[j] = ObjConver.getIntValue((String)StringUtil.matcherFirst((String)"[-\\d]+", (String)((String)matcherAll.get(j))));
            }
            featureIndex.put(temp.split(":")[1], list.size());
            list.add(is);
        }
        int[][] template = new int[list.size()][0];
        for (int i = 0; i < template.length; ++i) {
            template[i] = (int[])list.get(i);
        }
        this.config = new Config(template);
        return featureIndex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkModel(String modelPath) {
        try {
            InputStream is = IOUtil.getInputStream((String)modelPath);
            Throwable throwable = null;
            try {
                byte[] bytes = new byte[100];
                is.read(bytes);
                String string = new String(bytes);
                if (!string.startsWith("#mdl#")) return false;
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.warn("IO\u5f02\u5e38", (Throwable)e);
        }
        return false;
    }
}

