/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.HashMap;
import java.util.Map;
import org.forester.protein.BasicDomain;
import org.forester.protein.BinaryDomainCombination;
import org.forester.surfacing.BasicBinaryDomainCombination;

public class DirectedBinaryDomainCombination
extends BasicBinaryDomainCombination {
    private static final Map<Integer, DirectedBinaryDomainCombination> DDC_POOL = new HashMap<Integer, DirectedBinaryDomainCombination>();

    private DirectedBinaryDomainCombination(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("attempt to create binary domain combination using null");
        }
        this._id0 = BasicDomain.obtainIdAsShort(string);
        this._id1 = BasicDomain.obtainIdAsShort(string2);
    }

    public static final BinaryDomainCombination obtainInstance(String string) {
        if (string.indexOf("=") < 1) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + string + "]");
        }
        String[] stringArray = string.split("=");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + string + "]");
        }
        return DirectedBinaryDomainCombination.obtainInstance(stringArray[0], stringArray[1]);
    }

    public static final DirectedBinaryDomainCombination obtainInstance(String string, String string2) {
        int n = DirectedBinaryDomainCombination.calcCode(BasicDomain.obtainIdAsShort(string), BasicDomain.obtainIdAsShort(string2));
        if (DDC_POOL.containsKey(n)) {
            return DDC_POOL.get(n);
        }
        DirectedBinaryDomainCombination directedBinaryDomainCombination = new DirectedBinaryDomainCombination(string, string2);
        DDC_POOL.put(n, directedBinaryDomainCombination);
        return directedBinaryDomainCombination;
    }
}

