/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.phyloxml.PhyloXmlException;
import org.forester.io.parsers.phyloxml.PhyloXmlHandler;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PhyloXmlParser
implements PhylogenyParser {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String SAX_FEATURES_VALIDATION = "http://xml.org/sax/features/validation";
    public static final String APACHE_FEATURES_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    public static final String APACHE_FEATURES_VALIDATION_SCHEMA_FULL = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String APACHE_PROPERTIES_SCHEMA_EXTERNAL_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private static final boolean TIME = false;
    private Object _source;
    private boolean _valid;
    private boolean _zipped_inputstream;
    private int _error_count;
    private int _warning_count;
    private String _schema_location;
    private StringBuffer _error_messages;
    private StringBuffer _warning_messages;

    private PhyloXmlParser() {
        this.init();
        this.reset();
    }

    public int getErrorCount() {
        return this._error_count;
    }

    public StringBuffer getErrorMessages() {
        return this._error_messages;
    }

    private Reader getReaderFromZipFile() throws IOException {
        InputStreamReader inputStreamReader = null;
        ZipFile zipFile = new ZipFile(this.getSource().toString());
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || zipEntry.getSize() <= 0L) continue;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            break;
        }
        try {
            zipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputStreamReader;
    }

    private String getSchemaLocation() {
        return this._schema_location;
    }

    private Object getSource() {
        return this._source;
    }

    public int getWarningCount() {
        return this._warning_count;
    }

    public StringBuffer getWarningMessages() {
        return this._warning_messages;
    }

    private void init() {
        this.setZippedInputstream(false);
    }

    public boolean isValid() {
        return this._valid;
    }

    private boolean isZippedInputstream() {
        return this._zipped_inputstream;
    }

    @Override
    public Phylogeny[] parse() throws IOException, PhylogenyParserException {
        Phylogeny[] phylogenyArray;
        PhyloXmlHandler phyloXmlHandler;
        block23: {
            this.reset();
            phyloXmlHandler = new PhyloXmlHandler();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            try {
                if (!ForesterUtil.isEmpty(this.getSchemaLocation())) {
                    sAXParserFactory.setFeature(SAX_FEATURES_VALIDATION, true);
                    sAXParserFactory.setFeature(APACHE_FEATURES_VALIDATION_SCHEMA, true);
                    sAXParserFactory.setFeature(APACHE_FEATURES_VALIDATION_SCHEMA_FULL, true);
                }
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                sAXNotRecognizedException.printStackTrace();
                throw new PhylogenyParserException("sax not recognized exception: " + sAXNotRecognizedException.getLocalizedMessage());
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                sAXNotSupportedException.printStackTrace();
                throw new PhylogenyParserException("sax not supported exception: " + sAXNotSupportedException.getLocalizedMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
                throw new PhylogenyParserException("parser configuration exception: " + parserConfigurationException.getLocalizedMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new PhylogenyParserException("error while configuring sax parser: " + exception.getLocalizedMessage());
            }
            try {
                Object object;
                phylogenyArray = sAXParserFactory.newSAXParser();
                if (!ForesterUtil.isEmpty(this.getSchemaLocation())) {
                    phylogenyArray.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                    phylogenyArray.setProperty(JAXP_SCHEMA_SOURCE, this.getSchemaLocation());
                    phylogenyArray.setProperty(APACHE_PROPERTIES_SCHEMA_EXTERNAL_LOCATION, this.getSchemaLocation());
                }
                XMLReader xMLReader = phylogenyArray.getXMLReader();
                xMLReader.setContentHandler(phyloXmlHandler);
                xMLReader.setErrorHandler(new PhyloXmlParserErrorHandler());
                long l = 0L;
                if (this.getSource() instanceof File) {
                    if (!this.getSource().toString().toLowerCase().endsWith(".zip")) {
                        object = new FileInputStream((File)this.getSource());
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, "UTF-8");
                        xMLReader.parse(new InputSource(new BufferedReader(inputStreamReader)));
                    } else {
                        object = this.getReaderFromZipFile();
                        if (object == null) {
                            throw new PhylogenyParserException("zip file \"" + this.getSource() + "\" appears not to contain any entries");
                        }
                        xMLReader.parse(new InputSource(new BufferedReader((Reader)object)));
                    }
                    break block23;
                }
                if (this.getSource() instanceof InputSource) {
                    object = (InputSource)this.getSource();
                    ((InputSource)object).setEncoding("UTF-8");
                    xMLReader.parse((InputSource)object);
                    break block23;
                }
                if (this.getSource() instanceof InputStream) {
                    if (!this.isZippedInputstream()) {
                        object = (InputStream)this.getSource();
                        xMLReader.parse(new InputSource(new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"))));
                    } else {
                        object = new ZipInputStream((InputStream)this.getSource());
                        ((ZipInputStream)object).getNextEntry();
                        xMLReader.parse(new InputSource(new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"))));
                    }
                    break block23;
                }
                if (this.getSource() instanceof StringBuffer) {
                    object = new StringReader(this.getSource().toString());
                    xMLReader.parse(new InputSource((Reader)object));
                    break block23;
                }
                throw new PhylogenyParserException("phyloXML parser: attempt to parse object of unsupported type: \"" + this.getSource().getClass() + "\"");
            }
            catch (SAXException sAXException) {
                throw new PhylogenyParserException("failed to parse [" + this.getSource() + "]: " + sAXException.getLocalizedMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new PhylogenyParserException("failed to parse [" + this.getSource() + "]. Problem with XML parser configuration: " + parserConfigurationException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                throw new PhylogenyParserException("problem with input source: " + iOException.getLocalizedMessage());
            }
            catch (Exception exception) {
                throw new PhylogenyParserException(exception.getLocalizedMessage());
            }
            catch (Error error) {
                error.printStackTrace();
                throw new PhylogenyParserException("severe error: " + error.getLocalizedMessage());
            }
        }
        phylogenyArray = new Phylogeny[phyloXmlHandler.getPhylogenies().size()];
        int n = 0;
        for (Phylogeny phylogeny : phyloXmlHandler.getPhylogenies()) {
            phylogenyArray[n++] = phylogeny;
        }
        return phylogenyArray;
    }

    private void reset() {
        this._valid = true;
        this._error_count = 0;
        this._warning_count = 0;
        this._error_messages = new StringBuffer();
        this._warning_messages = new StringBuffer();
    }

    @Override
    public void setSource(Object object) {
        this._source = object;
    }

    public void setValidateAgainstSchema(String string) {
        this._schema_location = string;
    }

    public void setZippedInputstream(boolean bl) {
        this._zipped_inputstream = bl;
    }

    public static PhyloXmlParser createPhyloXmlParserXsdValidating() {
        PhyloXmlParser phyloXmlParser = new PhyloXmlParser();
        ClassLoader classLoader = PhyloXmlParser.class.getClassLoader();
        URL uRL = classLoader.getResource("resources/phyloxml.xsd");
        if (uRL == null) {
            throw new RuntimeException("failed to get URL for phyloXML XSD from jar file from [resources/phyloxml.xsd]");
        }
        phyloXmlParser.setValidateAgainstSchema(uRL.toString());
        return phyloXmlParser;
    }

    public static PhyloXmlParser createPhyloXmlParser() {
        PhyloXmlParser phyloXmlParser = new PhyloXmlParser();
        return phyloXmlParser;
    }

    @Override
    public String getName() {
        return "phyloXML Parser";
    }

    private class PhyloXmlParserErrorHandler
    extends DefaultHandler {
        private PhyloXmlParserErrorHandler() {
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            ++PhyloXmlParser.this._error_count;
            PhyloXmlParser.this._valid = false;
            throw new PhyloXmlException("phyloXML error at line " + sAXParseException.getLineNumber() + ": \n" + sAXParseException.getLocalizedMessage());
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            ++PhyloXmlParser.this._error_count;
            PhyloXmlParser.this._valid = false;
            throw new PhyloXmlException("fatal XML error at line " + sAXParseException.getLineNumber() + ": \n" + sAXParseException.getLocalizedMessage());
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            ++PhyloXmlParser.this._warning_count;
            if (PhyloXmlParser.this._error_messages.length() > 1) {
                PhyloXmlParser.this._error_messages.append(ForesterUtil.LINE_SEPARATOR);
            }
            PhyloXmlParser.this._warning_messages.append("[line: " + sAXParseException.getLineNumber() + "] " + sAXParseException.getMessage());
        }
    }
}

