/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.tools;

import java.util.Random;
import org.forester.msa.BasicMsa;
import org.forester.msa.Msa;

public class BootstrapResampler {
    private static void copyIdentifiers(Msa msa, Msa msa2) {
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            msa2.setIdentifier(i, msa.getIdentifier(i));
        }
    }

    private static void preconditionCheck(Msa msa, int n) {
        if (msa.getLength() < 2) {
            throw new IllegalArgumentException("Msa length cannot be smaller than two for bootstrap resampling");
        }
        if (msa.getNumberOfSequences() < 1) {
            throw new IllegalArgumentException("Attempt to bootstrap resample empty multiple sequence alignment");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Number of bootstrap resamples cannot be zero or negative");
        }
    }

    private static void preconditionCheck(int n, int n2) {
        if (n < 2) {
            throw new IllegalArgumentException("Msa length cannot be smaller than two for bootstrap resampling");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Number of bootstrap resamples cannot be zero or negative");
        }
    }

    public static Msa[] resample(Msa msa, int n, long l) {
        BootstrapResampler.preconditionCheck(msa, n);
        Random random = new Random(l);
        Msa[] msaArray = new Msa[n];
        for (int i = 0; i < n; ++i) {
            BasicMsa basicMsa = new BasicMsa(msa.getNumberOfSequences(), msa.getLength(), msa.getType());
            msaArray[i] = basicMsa;
            BootstrapResampler.copyIdentifiers(msa, basicMsa);
            for (int j = 0; j < msa.getLength(); ++j) {
                int n2 = random.nextInt(msa.getLength());
                for (int k = 0; k < msa.getNumberOfSequences(); ++k) {
                    basicMsa.setResidueAt(k, j, msa.getResidueAt(k, n2));
                }
            }
        }
        return msaArray;
    }

    public static int[][] createResampledColumnPositions(int n, int n2, long l) {
        BootstrapResampler.preconditionCheck(n, n2);
        Random random = new Random(l);
        int[][] nArray = new int[n2][n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i][j] = random.nextInt(n);
            }
        }
        return nArray;
    }
}

