/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.forester.archaeopteryx.AptxConstants;
import org.forester.archaeopteryx.NodeEditPanel;
import org.forester.archaeopteryx.NodePanel;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.ForesterUtil;

final class NodeFrame
extends JFrame {
    private static final long serialVersionUID = -6943510233968557246L;
    private final TreePanel _reepanel;
    private int _index = -1;

    NodeFrame(PhylogenyNode phylogenyNode, Phylogeny phylogeny, TreePanel treePanel, int n) {
        super("Node " + (ForesterUtil.isEmpty(phylogenyNode.getName()) ? Long.valueOf(phylogenyNode.getId()) : phylogenyNode.getName()));
        this._reepanel = treePanel;
        this.setSize(AptxConstants.NODE_FRAME_SIZE);
        this._index = n;
        Container container = this.getContentPane();
        NodePanel nodePanel = new NodePanel(phylogenyNode, this);
        container.add(nodePanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NodeFrame.this.close();
            }
        });
        this.setResizable(true);
        nodePanel.setVisible(true);
        this.setVisible(true);
    }

    void close() {
        this.remove();
        this.dispose();
    }

    NodeFrame(PhylogenyNode phylogenyNode, Phylogeny phylogeny, TreePanel treePanel, int n, String string) {
        super("Editable Node " + (ForesterUtil.isEmpty(phylogenyNode.getName()) ? Long.valueOf(phylogenyNode.getId()) : phylogenyNode.getName()));
        this._reepanel = treePanel;
        this.setSize(AptxConstants.NODE_FRAME_SIZE);
        this._index = n;
        Container container = this.getContentPane();
        final NodeEditPanel nodeEditPanel = new NodeEditPanel(phylogenyNode, treePanel, this);
        container.add((Component)nodeEditPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                try {
                    nodeEditPanel.writeAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                NodeFrame.this.remove();
                NodeFrame.this.dispose();
            }
        });
        this.setResizable(false);
        nodeEditPanel.setVisible(true);
        this.setVisible(true);
    }

    TreePanel getTreePanel() {
        return this._reepanel;
    }

    void remove() {
        if (this._index > -1) {
            this._reepanel.removeEditNodeFrame(this._index);
        }
    }
}

