/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.forester.go.GoId;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.OBOparser;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;
import org.forester.util.GeneralTable;

public class goac {
    private static final String ALL = "{ALL}";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String PRG_NAME = "goac";
    private static final String PRG_VERSION = "1.03";
    private static final String PRG_DATE = "2010.04.21";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/goac";

    private static void addStats(SortedMap<String, List<GoId>> sortedMap, GeneralTable<String, Double> generalTable) {
        for (String string : generalTable.getColumnIdentifiers()) {
            BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
            for (String string2 : sortedMap.keySet()) {
                if (string2.equals(ALL)) continue;
                Double d = generalTable.getValue(string, string2);
                basicDescriptiveStatistics.addValue(d == null ? 0.0 : d);
            }
            generalTable.setValue(string, "{AVG}", basicDescriptiveStatistics.arithmeticMean());
            generalTable.setValue(string, "{SUM}", basicDescriptiveStatistics.getSum());
            generalTable.setValue(string, "{MED}", basicDescriptiveStatistics.median());
            if (basicDescriptiveStatistics.getN() > 1) {
                generalTable.setValue(string, "{SD}", basicDescriptiveStatistics.sampleStandardDeviation());
            } else {
                generalTable.setValue(string, "{SD}", 0.0);
            }
            generalTable.setValue(string, "{MIN}", basicDescriptiveStatistics.getMin());
            generalTable.setValue(string, "{MAX}", basicDescriptiveStatistics.getMax());
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object22;
        Object object32;
        String string;
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2) || stringArray.length == 0) {
            goac.printHelp();
            System.exit(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (commandLineArguments.getNumberOfNames() != 3) {
            goac.printHelp();
            System.exit(-1);
        }
        if ((string = commandLineArguments.validateAllowedOptionsAsString(arrayList)).length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
        }
        File file = commandLineArguments.getFile(0);
        File file2 = commandLineArguments.getFile(1);
        File file3 = commandLineArguments.getFile(2);
        OBOparser oBOparser = new OBOparser(file, OBOparser.ReturnType.BASIC_GO_TERM);
        List<GoTerm> list = null;
        try {
            list = oBOparser.parse();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.toString());
        }
        Map<GoId, GoTerm> map = GoUtils.createGoIdToGoTermMap(list);
        ArrayList<GoId> arrayList2 = new ArrayList<GoId>();
        SortedMap<String, List<GoId>> sortedMap = null;
        try {
            sortedMap = GoUtils.parseGoIds(file2, "#", "");
        }
        catch (IOException iOException) {
            ForesterUtil.printErrorMessage(PRG_NAME, iOException.getMessage());
            System.exit(-1);
        }
        List list2 = (List)sortedMap.get("");
        for (Object object32 : list2) {
            if (!map.containsKey(object32)) {
                ForesterUtil.printErrorMessage(PRG_NAME, "\"" + object32 + "\" not present in \"" + file + "\"");
                System.exit(-1);
            }
            arrayList2.add((GoId)object32);
        }
        Object object4 = null;
        try {
            object4 = GoUtils.parseGoIds(file3, "#", ">");
        }
        catch (IOException iOException) {
            ForesterUtil.printErrorMessage(PRG_NAME, iOException.getMessage());
            System.exit(-1);
        }
        object32 = new ArrayList();
        for (Object object22 : object4.keySet()) {
            List list3 = (List)object4.get(object22);
            Object object5 = list3.iterator();
            while (object5.hasNext()) {
                object = (GoId)object5.next();
                if (!map.containsKey(object)) {
                    ForesterUtil.printErrorMessage(PRG_NAME, "GO id [" + object + "] not found in GO id to term map");
                    System.exit(-1);
                }
                object32.add(object);
            }
        }
        if (object4.size() > 1) {
            object4.put(ALL, object32);
        }
        GeneralTable generalTable = new GeneralTable();
        object22 = new GeneralTable();
        for (Object object5 : object4.keySet()) {
            System.out.println();
            System.out.println((String)object5 + "\t\t\t\t");
            object = (List)object4.get(object5);
            LinkedHashMap<GoId, Integer> linkedHashMap = null;
            try {
                linkedHashMap = GoUtils.countCategoriesId(arrayList2, (List<GoId>)object, map);
            }
            catch (Exception exception) {
                ForesterUtil.printErrorMessage(PRG_NAME, exception.getMessage());
                System.exit(-1);
            }
            int n = 0;
            for (GoId goId : linkedHashMap.keySet()) {
                n += ((Integer)linkedHashMap.get(goId)).intValue();
            }
            if (n > 0) {
                generalTable.setValue("{total}", object5, Double.valueOf(n));
            }
            for (GoId goId : linkedHashMap.keySet()) {
                int n2 = (Integer)linkedHashMap.get(goId);
                double d = 0.0;
                if (n > 0) {
                    d = 100.0 * (double)n2 / (double)n;
                }
                System.out.println(n2 + "\t" + n2 + "/" + n + "\t" + d + "\t" + goId + "\t" + map.get(goId).getName());
                generalTable.setValue(map.get(goId).getName(), object5, Double.valueOf(n2));
                ((GeneralTable)object22).setValue(map.get(goId).getName(), object5, d);
            }
        }
        goac.addStats((SortedMap<String, List<GoId>>)object4, generalTable);
        goac.addStats((SortedMap<String, List<GoId>>)object4, (GeneralTable<String, Double>)object22);
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println(generalTable.toString(ForesterUtil.FORMATTER_3));
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println(((GeneralTable)object22).toString(ForesterUtil.FORMATTER_3));
        System.out.println();
    }

    private static void printHelp() {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        System.out.println("Usage:");
        System.out.println();
        System.out.println("goac <file with all GO terms, in 'obo' format> <file with ancestral term ids> <file with go ids to be analyzed>");
        System.out.println();
        System.out.println();
    }
}

