/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.swing;

import com.approximatrix.charting.AbstractChart;
import com.approximatrix.charting.Chart;
import com.approximatrix.charting.Legend;
import com.approximatrix.charting.Title;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Map;
import javax.swing.JPanel;

public abstract class AbstractChartPanel
extends JPanel
implements Chart,
MouseMotionListener,
MouseListener,
Printable {
    public static final int PAGE_EXISTS = 0;
    public static final int NO_SUCH_PAGE = 1;
    protected AbstractChart chart;

    public AbstractChartPanel() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void addChartRenderer(AbstractChartRenderer renderer, int z) {
        this.chart.addChartRenderer(renderer, z);
    }

    @Override
    public Rectangle getBounds() {
        return this.chart.getBounds();
    }

    @Override
    public ChartDataModel getChartDataModel() {
        return this.chart.getChartDataModel();
    }

    @Override
    public Map<Integer, AbstractChartRenderer> getChartRenderer() {
        return this.chart.getChartRenderer();
    }

    @Override
    public AbstractChartRenderer getChartRenderer(int z) {
        return this.chart.getChartRenderer(z);
    }

    @Override
    public CoordSystem getCoordSystem() {
        return this.chart.getCoordSystem();
    }

    @Override
    public Legend getLegend() {
        return this.chart.getLegend();
    }

    @Override
    public Title getTitle() {
        return this.chart.getTitle();
    }

    @Override
    public void setBounds(Rectangle r) {
        this.chart.setBounds(r);
    }

    @Override
    public void setChartDataModel(ChartDataModel model) {
        this.chart.setChartDataModel(model);
    }

    public void setChartRenderer(Map renderer) {
        this.chart.setChartRenderer(renderer);
    }

    @Override
    public void setCoordSystem(CoordSystem c) {
        this.chart.setCoordSystem(c);
    }

    @Override
    public void setLegend(Legend l) {
        this.chart.setLegend(l);
    }

    @Override
    public void setTitle(Title t) {
        this.chart.setTitle(t);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void paint(Graphics graphics) {
        this.chart.setBounds(new Rectangle(this.getWidth(), this.getHeight()));
        this.chart.render((Graphics2D)graphics);
    }

    @Override
    public void render(Graphics2D g) {
        this.paint(g);
    }

    public void setRowColorModel(RowColorModel rcm) throws NullPointerException {
        this.chart.setRowColorModel(rcm);
    }

    public RowColorModel getRowColorModel() {
        return this.chart.getRowColorModel();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        int x = (int)pf.getImageableX();
        int y = (int)pf.getImageableY();
        g.translate(x, y);
        if (page == 0) {
            this.paint(g);
            return 0;
        }
        return 1;
    }
}

