/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.Transform;

import FCSalyzer.Transform.FCStransformer;
import edu.stanford.facs.logicle.Logicle;
import java.util.Vector;

public class LogicleTransformer
implements FCStransformer {
    public static final double[] Zero_Ranges = new double[]{0.0, -2.09743E-4, -4.22953E-4, -8.05936E-4, -0.002090205, -0.004079826, -0.008181532, -0.015438507, -0.031457352, -0.050903043, -0.105618344, -0.154199233, -0.206015896, -0.252666076, -0.309069615};
    public static final String[] Zero_percentages = new String[]{"0%", "0.02%", "0.04%", "0.08%", "0.2%", "0.4%", "0.8%", "1.5%", "3%", "5%", "10%", "15%", "20%", "25%", "30%"};
    public static final double[] W_Values = new double[]{0.0, 0.38, 0.5, 0.62, 0.81, 0.95, 1.1, 1.24, 1.4, 1.51, 1.68, 1.77, 1.84, 1.89, 1.94};
    private int neg_percentage;
    private long range;
    private Logicle theLogicle;
    private final double nearly_zero = 4.5E-16;
    private static final Vector<LogicleTransformer> allLogicles = new Vector();

    private LogicleTransformer(long range, int percentage_index) {
        this.range = range;
        this.neg_percentage = percentage_index;
        this.theLogicle = new Logicle(range, W_Values[percentage_index]);
    }

    public static synchronized LogicleTransformer getLogicleTransformer(long range, int percentage_index) {
        for (LogicleTransformer currL : allLogicles) {
            if (currL.range != range || currL.neg_percentage != percentage_index) continue;
            return currL;
        }
        LogicleTransformer nL = new LogicleTransformer(range, percentage_index);
        allLogicles.add(nL);
        return nL;
    }

    public static synchronized LogicleTransformer getLogicleTransformer(long range) {
        return LogicleTransformer.getLogicleTransformer(range, 4);
    }

    @Override
    public int getNegativePercentageIndex() {
        return this.neg_percentage;
    }

    @Override
    public int getApproximateNegativeRange() {
        return (int)this.inverse(0.0);
    }

    @Override
    public double scale(double value) {
        if (value < 4.5E-16 && value > 0.0) {
            value = 0.0;
        }
        return this.theLogicle.scale(value);
    }

    @Override
    public double inverse(double scale) {
        return this.theLogicle.inverse(scale);
    }
}

