/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FCS.rawData;

import FCSalyzer.FCS.rawData.FCS_data_metainfo;
import FCSalyzer.FCS.rawData.FCS_datafile;
import FCSalyzer.FCS.rawData.FCS_datafile_BottomUpByteorder_differentBytes;
import FCSalyzer.FCS.rawData.FCS_datafile_BottomUpByteorder_equalBytes;
import FCSalyzer.FCS.rawData.FCS_datafile_TopDownByteorder_differentBytes;
import FCSalyzer.FCS.rawData.FCS_datafile_TopDownByteorder_equalBytes;
import FCSalyzer.FCS.rawData.FCS_datafile_mixedByteorder_differentBytes;
import FCSalyzer.FCS.rawData.FCS_datafile_mixedByteorder_equalBytes;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.DataFormatException;

public class FCS_data_factory {
    private static List<FCS_datafile> openFiles = null;

    private FCS_data_factory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized FCS_datafile getFCS_data(File toOpen) throws IOException, DataFormatException {
        if (openFiles == null) {
            openFiles = Collections.synchronizedList(new ArrayList());
        }
        ArrayList<FCS_datafile> toRemove = new ArrayList<FCS_datafile>();
        FCS_datafile toReturn = null;
        List<FCS_datafile> list = openFiles;
        synchronized (list) {
            for (FCS_datafile currentFile : openFiles) {
                if (currentFile != null) {
                    if (!currentFile.metaInfo.FileName.equals(toOpen.getName()) || !currentFile.metaInfo.FilePath.equals(toOpen.getParent())) continue;
                    toReturn = currentFile;
                    continue;
                }
                toRemove.add(currentFile);
            }
        }
        openFiles.removeAll(toRemove);
        if (toReturn != null) {
            return toReturn;
        }
        FCS_data_metainfo newMeta = new FCS_data_metainfo(toOpen);
        toReturn = newMeta.sameByteCountForParams ? (newMeta.isTopDownOrder() ? new FCS_datafile_TopDownByteorder_equalBytes(newMeta) : (newMeta.isBottomUpOrder() ? new FCS_datafile_BottomUpByteorder_equalBytes(newMeta) : new FCS_datafile_mixedByteorder_equalBytes(newMeta))) : (newMeta.isTopDownOrder() ? new FCS_datafile_TopDownByteorder_differentBytes(newMeta) : (newMeta.isBottomUpOrder() ? new FCS_datafile_BottomUpByteorder_differentBytes(newMeta) : new FCS_datafile_mixedByteorder_differentBytes(newMeta)));
        openFiles.add(toReturn);
        return toReturn;
    }

    public static FCS_datafile getDummyData(String name, String path, int params) {
        return new FCS_datafile_mixedByteorder_equalBytes(FCS_data_metainfo.getDummyData(name, path, params));
    }
}

