/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FCS;

import FCSalyzer.FCS.FCS_RegionGatesHolder;
import FCSalyzer.FCS.FCS_containing;
import FCSalyzer.FCS.frameSelecting;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import staticStuff.staticMethods;

public class FCS_region
implements frameSelecting,
FCS_containing {
    private Polygon theShape = new Polygon();
    private Area theArea = null;
    private String name = "";
    private String lowerCaseName = "";
    private int paramX;
    private int paramY;
    private boolean isSelected = false;
    private FCS_RegionGatesHolder theRaG;
    public static final String XML_name = "Region";
    private static final String XML_regionName = "Name";
    private static final String XML_param_x = "X_Parameter";
    private static final String XML_param_y = "Y_Parameter";
    private static final String XML_polygon = "Polygon";
    private static final String XML_polygon_point = "Point";
    private static final String XML_polygon_index = "Index";
    private static final String XML_polygon_x = "X";
    private static final String XML_polygon_y = "Y";

    private FCS_region() {
    }

    public FCS_region(String paramName, int x, int y, FCS_RegionGatesHolder paramRaG) {
        this.theRaG = paramRaG;
        this.setName(paramName);
        if (this.name == null) {
            throw new IllegalArgumentException();
        }
        this.paramX = x;
        this.paramY = y;
        this.theRaG.updateGates(null);
    }

    public void add(Point paramPoint) {
        this.add(paramPoint.x, paramPoint.y);
    }

    public void add(int x, int y) {
        this.theShape.addPoint(x, y);
        this.theArea = new Area(this.theShape);
    }

    public boolean contains(double x, double y) {
        return this.theShape.contains(x, y);
    }

    @Override
    public boolean contains(double[] event) {
        if (this.paramX < event.length && this.paramY < event.length) {
            return this.contains(event[this.paramX], event[this.paramY]);
        }
        return false;
    }

    public Polygon getShape() {
        return this.theShape;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String paramName) {
        boolean oldNameExists;
        boolean bl = oldNameExists = !this.name.isEmpty();
        if (paramName == null) {
            return;
        }
        if ((paramName = paramName.trim()).isEmpty() || paramName.contains("\"") || paramName.contains("(") || paramName.contains(")") || paramName.toLowerCase().equals("and") || paramName.toLowerCase().equals("or") || paramName.toLowerCase().equals("not")) {
            return;
        }
        if (this.theRaG.nameExists(paramName)) {
            while (this.theRaG.nameExists(paramName = paramName + "-")) {
            }
        }
        String oldName = this.name;
        this.name = paramName;
        this.lowerCaseName = this.name.toLowerCase();
        if (oldNameExists) {
            this.theRaG.nameChanged(oldName, paramName);
        }
    }

    public boolean areRegionParameters(int x, int y) {
        return this.paramX == x && this.paramY == y;
    }

    public void toXML(Node parent) {
        Node r = staticMethods.addNode(parent, XML_name, null);
        staticMethods.addNode(r, XML_regionName, this.name);
        staticMethods.addNode(r, XML_param_x, this.paramX);
        staticMethods.addNode(r, XML_param_y, this.paramY);
        Node p = staticMethods.addNode(r, XML_polygon, null);
        for (int i = 0; i < this.theShape.npoints; ++i) {
            Node currentPoint = staticMethods.addNode(p, XML_polygon_point, null);
            staticMethods.addNode(currentPoint, XML_polygon_index, i);
            staticMethods.addNode(currentPoint, XML_polygon_x, this.theShape.xpoints[i]);
            staticMethods.addNode(currentPoint, XML_polygon_y, this.theShape.ypoints[i]);
        }
    }

    public static FCS_region fromXML(Node sourceNode, FCS_RegionGatesHolder theRaG) {
        FCS_region returnRegion = new FCS_region();
        returnRegion.theRaG = theRaG;
        ArrayList<Integer> xs = new ArrayList<Integer>();
        ArrayList<Integer> ys = new ArrayList<Integer>();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        Integer parameterX = null;
        Integer parameterY = null;
        NodeList nL = sourceNode.getChildNodes();
        for (int i = 0; i < nL.getLength(); ++i) {
            Node current = nL.item(i);
            if (current.getNodeName().equals(XML_regionName)) {
                returnRegion.name = staticMethods.getNodeText(current);
                returnRegion.lowerCaseName = returnRegion.name.toLowerCase();
                continue;
            }
            if (current.getNodeName().equals(XML_param_x)) {
                parameterX = staticMethods.getNodeInteger(current, null);
                continue;
            }
            if (current.getNodeName().equals(XML_param_y)) {
                parameterY = staticMethods.getNodeInteger(current, null);
                continue;
            }
            if (!current.getNodeName().equals(XML_polygon)) continue;
            NodeList polygon = current.getChildNodes();
            for (int j = 0; j < polygon.getLength(); ++j) {
                if (!polygon.item(j).getNodeName().equals(XML_polygon_point)) continue;
                NodeList point = polygon.item(j).getChildNodes();
                int x = 0;
                int y = 0;
                int index = 0;
                for (int k = 0; k < point.getLength(); ++k) {
                    Node pointChild = point.item(k);
                    if (pointChild.getNodeName().equals(XML_polygon_index)) {
                        index = staticMethods.getNodeInteger(pointChild, index);
                        continue;
                    }
                    if (pointChild.getNodeName().equals(XML_polygon_x)) {
                        x = staticMethods.getNodeInteger(pointChild, x);
                        continue;
                    }
                    if (!pointChild.getNodeName().equals(XML_polygon_y)) continue;
                    y = staticMethods.getNodeInteger(pointChild, y);
                }
                xs.add(x);
                ys.add(y);
                indices.add(index);
            }
        }
        if (returnRegion.name.isEmpty()) {
            return null;
        }
        if (indices.isEmpty()) {
            return null;
        }
        if (parameterX == null) {
            return null;
        }
        if (parameterY == null) {
            return null;
        }
        returnRegion.paramX = parameterX;
        returnRegion.paramY = parameterY;
        int[] xpoints = new int[indices.size()];
        int[] ypoints = new int[xpoints.length];
        for (int i = 0; i < xpoints.length; ++i) {
            xpoints[((Integer)indices.get((int)i)).intValue()] = (Integer)xs.get(i);
            ypoints[((Integer)indices.get((int)i)).intValue()] = (Integer)ys.get(i);
        }
        Polygon shape = new Polygon();
        for (int i = 0; i < xpoints.length; ++i) {
            shape.addPoint(xpoints[i], ypoints[i]);
        }
        returnRegion.setShape(shape);
        return returnRegion;
    }

    protected void addPrefix(String prefix, int count, StringBuilder addTo) {
        for (int i = 0; i < count; ++i) {
            addTo.append(prefix);
        }
    }

    public void setSelected(boolean paramSelected) {
        this.isSelected = paramSelected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public boolean isNearFrame(Point toCheck, int width, int height) {
        Rectangle testArea = new Rectangle(toCheck.x - width, toCheck.y - height, width * 2, height * 2);
        if (this.theArea.contains(testArea)) {
            return false;
        }
        return this.theArea.intersects(testArea);
    }

    private boolean isNear(int start_x, int start_y, int end_x, int end_y, int px, int py, int width) {
        int line_width = end_x - start_x;
        int line_height = end_y - start_y;
        int adjust_x = px - start_x;
        int adjust_y = py - start_y;
        float kx = (float)line_height / (float)line_width;
        int calc_y = Math.round(kx * (float)adjust_x);
        if (Math.abs(calc_y - adjust_y) < width) {
            return true;
        }
        float ky = (float)line_width / (float)line_height;
        int calc_x = Math.round(ky * (float)adjust_y);
        return Math.abs(calc_x - adjust_x) < width;
    }

    public int getParamX() {
        return this.paramX;
    }

    public int getParamY() {
        return this.paramY;
    }

    public Object getLowerCaseName() {
        return this.lowerCaseName;
    }

    public void setShape(Polygon newShape) {
        newShape.invalidate();
        this.theShape = newShape;
        this.theArea = new Area(this.theShape);
    }

    @Override
    public String toString() {
        return "\"" + this.getName() + "\"";
    }
}

