/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.jobs;

import java.util.ArrayList;
import java.util.List;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.Strategy;
import org.encog.ml.train.strategy.end.EndTrainingStrategy;
import org.encog.neural.networks.BasicNetwork;

public abstract class TrainingJob {
    private BasicNetwork network;
    private MLDataSet training;
    private final List<Strategy> strategies = new ArrayList<Strategy>();
    private boolean loadToMemory;
    private MLTrain train;
    private Throwable error;

    public TrainingJob(BasicNetwork network, MLDataSet training, boolean loadToMemory) {
        this.network = network;
        this.training = training;
        this.loadToMemory = loadToMemory;
    }

    public abstract void createTrainer(boolean var1);

    public Throwable getError() {
        return this.error;
    }

    public BasicNetwork getNetwork() {
        return this.network;
    }

    public List<Strategy> getStrategies() {
        return this.strategies;
    }

    public MLTrain getTrain() {
        return this.train;
    }

    public MLDataSet getTraining() {
        return this.training;
    }

    public boolean isLoadToMemory() {
        return this.loadToMemory;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public void setLoadToMemory(boolean loadToMemory) {
        this.loadToMemory = loadToMemory;
    }

    public void setNetwork(BasicNetwork network) {
        this.network = network;
    }

    public void setTrain(MLTrain train) {
        this.train = train;
    }

    public void setTraining(MLDataSet training) {
        this.training = training;
    }

    public boolean shouldContinue() {
        for (Strategy strategy : this.train.getStrategies()) {
            EndTrainingStrategy end;
            if (!(strategy instanceof EndTrainingStrategy) || !(end = (EndTrainingStrategy)strategy).shouldStop()) continue;
            return false;
        }
        return true;
    }
}

