/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.hmm.alog;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.hmm.HiddenMarkovModel;
import org.encog.ml.hmm.alog.ForwardBackwardCalculator;

public class ForwardBackwardScaledCalculator
extends ForwardBackwardCalculator {
    private final double[] ctFactors;
    private double lnProbability;

    public ForwardBackwardScaledCalculator(MLDataSet oseq, HiddenMarkovModel hmm) {
        this(oseq, hmm, EnumSet.of(ForwardBackwardCalculator.Computation.ALPHA));
    }

    public ForwardBackwardScaledCalculator(MLDataSet oseq, HiddenMarkovModel hmm, EnumSet<ForwardBackwardCalculator.Computation> flags) {
        if (oseq.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.ctFactors = new double[oseq.size()];
        Arrays.fill(this.ctFactors, 0.0);
        this.computeAlpha(hmm, oseq);
        if (flags.contains((Object)ForwardBackwardCalculator.Computation.BETA)) {
            this.computeBeta(hmm, oseq);
        }
        this.computeProbability(oseq, hmm, flags);
    }

    @Override
    protected void computeAlpha(HiddenMarkovModel hmm, MLDataSet oseq) {
        this.alpha = new double[oseq.size()][hmm.getStateCount()];
        for (int i = 0; i < hmm.getStateCount(); ++i) {
            this.computeAlphaInit(hmm, oseq.get(0), i);
        }
        this.scale(this.ctFactors, this.alpha, 0);
        Iterator seqIterator = oseq.iterator();
        if (seqIterator.hasNext()) {
            seqIterator.next();
        }
        for (int t = 1; t < oseq.size(); ++t) {
            MLDataPair observation = (MLDataPair)seqIterator.next();
            for (int i = 0; i < hmm.getStateCount(); ++i) {
                this.computeAlphaStep(hmm, observation, t, i);
            }
            this.scale(this.ctFactors, this.alpha, t);
        }
    }

    @Override
    protected void computeBeta(HiddenMarkovModel hmm, MLDataSet oseq) {
        this.beta = new double[oseq.size()][hmm.getStateCount()];
        for (int i = 0; i < hmm.getStateCount(); ++i) {
            this.beta[oseq.size() - 1][i] = 1.0 / this.ctFactors[oseq.size() - 1];
        }
        for (int t = oseq.size() - 2; t >= 0; --t) {
            int i = 0;
            while (i < hmm.getStateCount()) {
                this.computeBetaStep(hmm, oseq.get(t + 1), t, i);
                double[] dArray = this.beta[t];
                int n = i++;
                dArray[n] = dArray[n] / this.ctFactors[t];
            }
        }
    }

    private void computeProbability(MLDataSet oseq, HiddenMarkovModel hmm, EnumSet<ForwardBackwardCalculator.Computation> flags) {
        this.lnProbability = 0.0;
        for (int t = 0; t < oseq.size(); ++t) {
            this.lnProbability += Math.log(this.ctFactors[t]);
        }
        this.probability = Math.exp(this.lnProbability);
    }

    public double lnProbability() {
        return this.lnProbability;
    }

    private void scale(double[] ctFactors, double[][] array, int t) {
        double[] table = array[t];
        double sum = 0.0;
        for (double element : table) {
            sum += element;
        }
        ctFactors[t] = sum;
        int i = 0;
        while (i < table.length) {
            int n = i++;
            table[n] = table[n] / sum;
        }
    }
}

