/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.auto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.EncogError;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.auto.AutoFloatColumn;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class AutoFloatDataSet
implements Serializable,
MLDataSet {
    private int sourceInputCount;
    private int sourceIdealCount;
    private int inputWindowSize;
    private int outputWindowSize;
    private List<AutoFloatColumn> columns = new ArrayList<AutoFloatColumn>();
    private float normalizedMax = 1.0f;
    private float normalizedMin = -1.0f;
    private boolean normalizationEnabled = false;

    public AutoFloatDataSet(int theInputCount, int theIdealCount, int theInputWindowSize, int theOutputWindowSize) {
        this.sourceInputCount = theInputCount;
        this.sourceIdealCount = theIdealCount;
        this.inputWindowSize = theInputWindowSize;
        this.outputWindowSize = theOutputWindowSize;
    }

    @Override
    public Iterator<MLDataPair> iterator() {
        return new AutoFloatIterator();
    }

    @Override
    public int getIdealSize() {
        return this.sourceIdealCount * this.outputWindowSize;
    }

    @Override
    public int getInputSize() {
        return this.sourceInputCount * this.inputWindowSize;
    }

    @Override
    public boolean isSupervised() {
        return this.getIdealSize() > 0;
    }

    @Override
    public long getRecordCount() {
        if (this.columns.size() == 0) {
            return 0L;
        }
        int totalRows = this.columns.get(0).getData().length;
        int windowSize = this.inputWindowSize + this.outputWindowSize;
        return totalRows - windowSize + 1;
    }

    @Override
    public void getRecord(long index, MLDataPair pair) {
        int columnID = 0;
        int inputIndex = 0;
        for (int i = 0; i < this.sourceInputCount; ++i) {
            AutoFloatColumn column = this.columns.get(columnID++);
            for (int j = 0; j < this.inputWindowSize; ++j) {
                pair.getInputArray()[inputIndex++] = this.normalizationEnabled ? (double)column.getNormalized((int)index + j, this.normalizedMin, this.normalizedMax) : (double)column.getData()[(int)index + j];
            }
        }
        int idealIndex = 0;
        for (int i = 0; i < this.sourceIdealCount; ++i) {
            AutoFloatColumn column = this.columns.get(columnID++);
            for (int j = 0; j < this.outputWindowSize; ++j) {
                pair.getIdealArray()[idealIndex++] = this.normalizationEnabled ? (double)column.getNormalized((int)((long)this.inputWindowSize + index + (long)j), this.normalizedMin, this.normalizedMax) : (double)column.getData()[(int)((long)this.inputWindowSize + index + (long)j)];
            }
        }
    }

    @Override
    public MLDataSet openAdditional() {
        return this;
    }

    @Override
    public void add(MLData data1) {
        throw new EncogError("Add's not supported by this dataset.");
    }

    @Override
    public void add(MLData inputData, MLData idealData) {
        throw new EncogError("Add's not supported by this dataset.");
    }

    @Override
    public void add(MLDataPair inputData) {
        throw new EncogError("Add's not supported by this dataset.");
    }

    @Override
    public void close() {
    }

    @Override
    public int size() {
        return (int)this.getRecordCount();
    }

    @Override
    public MLDataPair get(int index) {
        if (index >= this.size()) {
            return null;
        }
        MLDataPair result = BasicMLDataPair.createPair(this.getInputSize(), this.getIdealSize());
        this.getRecord(index, result);
        return result;
    }

    public void addColumn(float[] data) {
        AutoFloatColumn column = new AutoFloatColumn(data);
        this.columns.add(column);
    }

    public void loadCSV(String filename, boolean headers, CSVFormat format, int[] input, int[] ideal) {
        ReadCSV csv = new ReadCSV(filename, headers, format);
        int lineCount = 0;
        while (csv.next()) {
            ++lineCount;
        }
        csv.close();
        float[][] data = new float[input.length + ideal.length][lineCount];
        csv = new ReadCSV(filename, headers, format);
        int rowIndex = 0;
        while (csv.next()) {
            int i;
            int columnIndex = 0;
            for (i = 0; i < input.length; ++i) {
                data[columnIndex++][rowIndex] = (float)csv.getDouble(input[i]);
            }
            for (i = 0; i < ideal.length; ++i) {
                data[columnIndex++][rowIndex] = (float)csv.getDouble(ideal[i]);
            }
            ++rowIndex;
        }
        csv.close();
        for (int i = 0; i < data.length; ++i) {
            this.addColumn(data[i]);
        }
    }

    public float getNormalizedMax() {
        return this.normalizedMax;
    }

    public void setNormalizedMax(float normalizedMax) {
        this.normalizedMax = normalizedMax;
        this.normalizationEnabled = true;
    }

    public float getNormalizedMin() {
        return this.normalizedMin;
    }

    public void setNormalizedMin(float normalizedMin) {
        this.normalizedMin = normalizedMin;
        this.normalizationEnabled = true;
    }

    public boolean isNormalizationEnabled() {
        return this.normalizationEnabled;
    }

    public void setNormalizationEnabled(boolean normalizationEnabled) {
        this.normalizationEnabled = normalizationEnabled;
    }

    public class AutoFloatIterator
    implements Iterator<MLDataPair> {
        private int currentIndex = 0;

        @Override
        public final boolean hasNext() {
            return this.currentIndex < AutoFloatDataSet.this.size();
        }

        @Override
        public final MLDataPair next() {
            if (!this.hasNext()) {
                return null;
            }
            return AutoFloatDataSet.this.get(this.currentIndex++);
        }

        @Override
        public final void remove() {
            throw new EncogError("Called remove, unsupported operation.");
        }
    }
}

