/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;

public class IconSelection
extends JDialog {
    JList icons;
    List<String> iconKeys;
    DefaultListModel listModel;
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    private boolean okPressed = false;
    private int selected = -1;
    private JDialog parent;

    public IconSelection(JDialog parent, String initialSelection) {
        super(parent, Globals.lang("Select icon"), true);
        this.parent = parent;
        this.init(initialSelection);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.okPressed = false;
            this.selected = -1;
        }
        super.setVisible(visible);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public String getSelectedIconKey() {
        if (this.selected >= 0) {
            return this.iconKeys.get(this.selected);
        }
        return null;
    }

    private void init(String initialSelection) {
        int initSelIndex = -1;
        this.iconKeys = new ArrayList<String>();
        Map<String, String> icns = GUIGlobals.getAllIcons();
        LinkedHashSet<ImageIcon> iconSet = new LinkedHashSet<ImageIcon>();
        for (String key : icns.keySet()) {
            ImageIcon icon = GUIGlobals.getImage(key);
            if (!iconSet.contains(icon)) {
                this.iconKeys.add(key);
                if (key.equals(initialSelection)) {
                    initSelIndex = this.iconKeys.size() - 1;
                }
            }
            iconSet.add(icon);
        }
        this.listModel = new DefaultListModel();
        this.icons = new JList(this.listModel);
        Iterator iterator = iconSet.iterator();
        while (iterator.hasNext()) {
            this.listModel.addElement(new JLabel((Icon)iterator.next()));
        }
        if (initSelIndex >= 0) {
            this.icons.setSelectedIndex(initSelIndex);
        }
        class MyRenderer
        implements ListCellRenderer {
            JLabel comp = new JLabel();

            public MyRenderer() {
                this.comp.setOpaque(true);
                this.comp.setIconTextGap(0);
                this.comp.setHorizontalAlignment(0);
            }

            public Component getListCellRendererComponent(JList list, Object value, int i, boolean isSelected, boolean hasFocus) {
                this.comp.setText(null);
                this.comp.setIcon(((JLabel)value).getIcon());
                if (isSelected) {
                    this.comp.setBackground(list.getSelectionBackground());
                    this.comp.setForeground(list.getSelectionForeground());
                    this.comp.setBorder(BorderFactory.createEtchedBorder());
                } else {
                    this.comp.setBackground(list.getBackground());
                    this.comp.setForeground(list.getForeground());
                    this.comp.setBorder(null);
                }
                return this.comp;
            }
        }
        this.icons.setCellRenderer(new MyRenderer());
        this.icons.setSelectionMode(0);
        this.icons.setLayoutOrientation(2);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IconSelection.this.okPressed = true;
                if (IconSelection.this.icons.getSelectedValue() != null) {
                    IconSelection.this.selected = IconSelection.this.icons.getSelectedIndex();
                }
                IconSelection.this.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IconSelection.this.okPressed = false;
                IconSelection.this.dispose();
            }
        });
        this.icons.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    // empty if block
                }
            }
        });
        this.getContentPane().add((Component)new JScrollPane(this.icons), "Center");
        this.getContentPane().add((Component)bb.getPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }
}

