/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp.termination.strategies;

import java.util.Vector;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPReportBuilder;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.RTCPTransmitter;
import net.sf.fmj.media.rtp.SSRCCache;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.FeedbackCache;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.ReceiverReporting;
import org.jitsi.service.neomedia.RTCPPacketTransformer;
import org.jitsi.service.neomedia.RTCPTerminationStrategy;
import org.jitsi.service.neomedia.RTPTranslator;

public class BasicRTCPTerminationStrategy
implements RTCPTerminationStrategy,
RTCPPacketTransformer,
RTCPReportBuilder {
    private RTCPTransmitter rtcpTransmitter;
    private final ReceiverReporting receiverReporting;
    private RTPTranslator translator;
    private final FeedbackCache feedbackCache = new FeedbackCache();

    public FeedbackCache getFeedbackCache() {
        return this.feedbackCache;
    }

    public BasicRTCPTerminationStrategy() {
        this.receiverReporting = new ReceiverReporting(this);
        this.reset();
    }

    public RTCPPacket[] makeReports() {
        return this.receiverReporting.makeReports();
    }

    public void reset() {
    }

    public void setRTCPTransmitter(RTCPTransmitter rtcpTransmitter) {
        if (rtcpTransmitter != this.rtcpTransmitter) {
            this.rtcpTransmitter = rtcpTransmitter;
            this.onRTCPTransmitterChanged();
        }
    }

    private void onRTCPTransmitterChanged() {
        SSRCCache c;
        RTCPTransmitter t = this.rtcpTransmitter;
        if (t != null && (c = t.cache) != null) {
            c.audio = false;
        }
    }

    public RTCPTransmitter getRTCPTransmitter() {
        return this.rtcpTransmitter;
    }

    @Override
    public RTCPPacketTransformer getRTCPPacketTransformer() {
        return this;
    }

    @Override
    public RTCPReportBuilder getRTCPReportBuilder() {
        return this;
    }

    @Override
    public void setRTPTranslator(RTPTranslator translator) {
        this.translator = translator;
    }

    @Override
    public RTPTranslator getRTPTranslator() {
        return this.translator;
    }

    @Override
    public RTCPCompoundPacket transformRTCPPacket(RTCPCompoundPacket inPacket) {
        if (inPacket == null || inPacket.packets == null || inPacket.packets.length == 0) {
            return inPacket;
        }
        Vector<Object> outPackets = new Vector<Object>(inPacket.packets.length);
        RTCPReportBlock[] reports = null;
        RTCPREMBPacket remb = null;
        Integer ssrc = 0;
        block8: for (RTCPPacket p : inPacket.packets) {
            switch (p.type) {
                case 201: {
                    RTCPRRPacket rr = (RTCPRRPacket)p;
                    reports = rr.reports;
                    ssrc = rr.ssrc;
                    continue block8;
                }
                case 200: {
                    RTCPSRPacket sr = (RTCPSRPacket)p;
                    outPackets.add(sr);
                    reports = sr.reports;
                    ssrc = sr.ssrc;
                    sr.reports = new RTCPReportBlock[0];
                    continue block8;
                }
                case 206: {
                    RTCPFBPacket psfb = (RTCPFBPacket)p;
                    switch (psfb.fmt) {
                        case 15: {
                            remb = (RTCPREMBPacket)p;
                            ssrc = (int)remb.senderSSRC;
                            continue block8;
                        }
                    }
                    outPackets.add((Object)psfb);
                    continue block8;
                }
                default: {
                    outPackets.add(p);
                }
            }
        }
        this.feedbackCache.update(ssrc, reports, remb);
        Object[] outarr = new RTCPPacket[outPackets.size()];
        outPackets.copyInto(outarr);
        RTCPCompoundPacket outPacket = new RTCPCompoundPacket((RTCPPacket[])outarr);
        return outPacket;
    }
}

