/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec;

import java.util.HashMap;
import org.jitsi.impl.neomedia.codec.EncodingConfigurationImpl;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.format.MediaFormat;

public class EncodingConfigurationConfigImpl
extends EncodingConfigurationImpl {
    private String propPrefix;
    private ConfigurationService configurationService = LibJitsi.getConfigurationService();

    public EncodingConfigurationConfigImpl(String prefix) {
        this.propPrefix = prefix;
        this.loadConfig();
    }

    private void loadConfig() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String pName : this.configurationService.getPropertyNamesByPrefix(this.propPrefix, false)) {
            properties.put(pName, this.configurationService.getString(pName));
        }
        this.loadProperties(properties);
    }

    @Override
    public void setPriority(MediaFormat encoding, int priority) {
        super.setPriority(encoding, priority);
        this.configurationService.setProperty(this.propPrefix + "." + this.getEncodingPreferenceKey(encoding), priority);
    }
}

